//
// This file is part of ProSMART.
//

#ifndef restrain_align_handler_H
#define restrain_align_handler_H

#include "restrainClass_Residues.h"

struct residue_alignment
{  
  int res1;
  int res2;
  double dist;
  double sideAV;
	double bfac;
};

ostream& operator<<(ostream&, residue_alignment &);

vector<vector<string> > file_read_bonds(string &, char, int);
vector<residue_alignment> align_to_self(PDBfile &);
vector<residue_alignment> file_read_alignment(string &, vector<res_corresp> &, vector<res_corresp> &, int);
vector<residue_alignment> filter_alignment(vector<residue_alignment> &, double, double);
vector<residue_alignment> get_atomic_alignment(vector<residue_alignment> &, Residues &, Residues &, int);
Array1D<int> get_atom_indexes(vector<residue_alignment> &, int);

#endif
