//
// This file is part of ProSMART.
//

#include "restrain_atomic_restraints.h"

vector<string> info_vector(string filename1, string filename2, char chain1, char chain2, int pdb1_size, int pdb2_size, double dist_param, double sigma, double MIN_DISTANCE, int restraints_size, string PROGRAM_VERSION, double align_cutoff, double side_cutoff, double sigma_cutoff_multiplier, double SIGMA_WEIGHT)
{
  vector<string> info;
  /*stringstream ss;
	 
	 ss << "# ProSMART RESTRAIN";
	 info.push_back(ss.str()); ss.str("");
	 ss << "#";
	 info.push_back(ss.str()); ss.str("");
	 ss << "# Input Files:";
	 info.push_back(ss.str()); ss.str("");
	 ss << "# File 1:\t" << filename1 << "  \tchain " << chain1 << "\t\t" << pdb1_size << " atoms used";
	 info.push_back(ss.str()); ss.str("");
	 ss << "# File 2:\t" << filename2 << "  \tchain " << chain2 << "\t\t" << pdb2_size << " atoms used";
	 info.push_back(ss.str()); ss.str("");
	 ss << "#";
	 info.push_back(ss.str()); ss.str("");
	 ss << "# Parameters:";
	 info.push_back(ss.str()); ss.str("");
	 ss << "# Max Restraint Dist: " << dist_param;
	 info.push_back(ss.str()); ss.str("");
	 ss << "# Min Restraint Dist: " << MIN_DISTANCE;
	 info.push_back(ss.str()); ss.str("");
	 ss << "# Default Sigma: " << sigma;
	 info.push_back(ss.str()); ss.str("");
	 ss << "# Sigma Multiplier: " << sigma_cutoff_multiplier;
	 info.push_back(ss.str()); ss.str("");
	 ss << "# Sigma Weight: " << SIGMA_WEIGHT;
	 info.push_back(ss.str()); ss.str("");
	 ss << "# Align Score Cutoff: " << align_cutoff;
	 info.push_back(ss.str()); ss.str("");
	 ss << "# SideAV Score Cutoff: " << side_cutoff;
	 info.push_back(ss.str()); ss.str("");
	 ss << "#";
	 info.push_back(ss.str()); ss.str("");
	 ss << "# " << restraints_size << " restraints identified";
	 info.push_back(ss.str()); ss.str("");
	 ss << "# ";
	 info.push_back(ss.str()); ss.str("");
	 ss << "# TAG: " << delete_ext(filename1) << "_" << chain1 << "_" << delete_ext(filename2) << "_" << chain2;
	 info.push_back(ss.str()); ss.str("");
	 */
  return info;
}

void get_atom_restraints(vector<residue_alignment> &restraints1, vector<residue_alignment> &restraints2, vector<residue_alignment> &atom_align, vector<vector<int> > &close_atoms1, vector<vector<int> > &close_atoms2, Array1D<int> &atom_idx, PDBfile &pdb1, PDBfile &pdb2, double MIN_DISTANCE, int HELIX)
{
  residue_alignment temp;
  int atom1_index;
  
  if(HELIX == 0){
		for(unsigned int i=0; i<atom_align.size(); i++){	//for each aligned atom pair
			/*cout << endl << atom_align[i];
			cout << " " << pdb1.get_resnum(atom_align[i].res1)
			<< " " << pdb1.get_resid(atom_align[i].res1)
			<< " " << pdb1.get_atom(atom_align[i].res1)
			<< " " << pdb2.get_resnum(atom_align[i].res2)
			<< " " << pdb2.get_resid(atom_align[i].res2)
			<< " " << pdb2.get_atom(atom_align[i].res2)
			<< endl;*/
			//cout << "\t" << close_atoms1[atom_align[i].res1];
			//cout << "\t" << close_atoms2[atom_align[i].res2];
			for(unsigned int j=0; j<close_atoms1[atom_align[i].res1].size(); j++){	//for each atom close to atom i in protein 1
				atom1_index = atom_idx[close_atoms1[atom_align[i].res1][j]];
				if(atom1_index >= 0){											// <0 implies not used, eg alt conformation
					/*cout << "\t" << j << "\t" << close_atoms1[atom_align[i].res1][j];
					 cout << " " << pdb1.get_resnum(close_atoms1[atom_align[i].res1][j])
					 << " " << pdb1.get_resid(close_atoms1[atom_align[i].res1][j])
					 << " " << pdb1.get_atom(close_atoms1[atom_align[i].res1][j]);
					 cout << "\t" << atom_align[atom1_index].res2;
					 cout << " " << pdb1.get_resnum(atom_align[atom1_index].res2)
					 << " " << pdb1.get_resid(atom_align[atom1_index].res2)
					 << " " << pdb1.get_atom(atom_align[atom1_index].res2) << endl;*/
					for(unsigned int k=0; k<close_atoms2[atom_align[i].res2].size(); k++){	//for each atom close to atom i in protein 2
						if(close_atoms2[atom_align[i].res2][k] == atom_align[atom1_index].res2){	
							//if atom j in protein 1 corresponds to atom k in protein 2, then the atom pair in question has been found to be close to atom pair i in both proteins
							temp.res1 = atom_align[i].res2;
							temp.res2 = atom_align[atom1_index].res2;
							temp.dist = pdb2.get_distance(temp.res1,temp.res2);
							if(temp.dist >= MIN_DISTANCE){	//don't want restraints with distances lower than MIN_DISTANCE
								temp.bfac = pdb2.get_av_bfact(temp.res1,temp.res2);		//bfactors of external structure
								restraints2.push_back(temp);
								temp.res1 = atom_align[i].res1;
								temp.res2 = close_atoms1[atom_align[i].res1][j];
								temp.dist = pdb1.get_distance(temp.res1,temp.res2);
								temp.bfac = pdb1.get_av_bfact(temp.res1,temp.res2);		//bfactors of target structure
								restraints1.push_back(temp);
							}
							break;
						}
					}
					//cout << endl;
				}
			}
		}
		
  } else {	//for repetitive structure restraints
		
		for(unsigned int i=0; i<atom_align.size(); i++){	//for each aligned atom pair
			/*cout << endl << atom_align[i];
			 cout << " " << pdb1.get_resnum(atom_align[i].res1)
			 << " " << pdb1.get_resid(atom_align[i].res1)
			 << " " << pdb1.get_atom(atom_align[i].res1)
			 << " " << pdb2.get_resnum(atom_align[i].res2)
			 << " " << pdb2.get_resid(atom_align[i].res2)
			 << " " << pdb2.get_atom(atom_align[i].res2)
			 << endl;
			 cout << "\tpdb1: " << close_atoms1[atom_align[i].res1];
			 cout << "\tpdb2: " << close_atoms2[atom_align[i].res2] << endl;*/
			for(unsigned int j=0; j<close_atoms2[atom_align[i].res2].size(); j++){	//for each atom close to atom i in protein 2
				/*cout << "\t" << j << "\t" << close_atoms2[atom_align[i].res2][j];
				 cout << " " << pdb2.get_resnum(close_atoms2[atom_align[i].res2][j])
				 << " " << pdb2.get_resid(close_atoms2[atom_align[i].res2][j])
				 << " " << pdb2.get_atom(close_atoms2[atom_align[i].res2][j]);
				 cout << "\t" << "target in pdb1: "
				 << pdb1.get_resnum(atom_align[i].res1)+pdb2.get_resnum(close_atoms2[atom_align[i].res2][j])
				 << " " << pdb2.get_atom(close_atoms2[atom_align[i].res2][j]);	*/
				for(unsigned int k=0; k<close_atoms1[atom_align[i].res1].size(); k++){	//for each atom close to atom i in protein 1
					if(pdb1.get_resnum(close_atoms1[atom_align[i].res1][k]) == pdb1.get_resnum(atom_align[i].res1)+pdb2.get_resnum(close_atoms2[atom_align[i].res2][j])){
						if(pdb1.get_atom(close_atoms1[atom_align[i].res1][k]) == pdb2.get_atom(close_atoms2[atom_align[i].res2][j])){
							temp.res1 = atom_align[i].res2;
							temp.res2 = close_atoms2[atom_align[i].res2][j];
							temp.dist = pdb2.get_distance(temp.res1,temp.res2);
							temp.bfac = pdb2.get_av_bfact(temp.res1,temp.res2);		//only interested in bfactors of external structure
							if(temp.dist >= MIN_DISTANCE){	//don't want restraints with distances lower than MIN_DISTANCE
								restraints2.push_back(temp);
								temp.res1 = atom_align[i].res1;
								temp.res2 = close_atoms1[atom_align[i].res1][k];
								temp.dist = pdb1.get_distance(temp.res1,temp.res2);
								restraints1.push_back(temp);
								//cout << "\trestraint:  "
								//<< "res1: " << atom_align[i].res1 << " " << close_atoms1[atom_align[i].res1][k] << " " << pdb1.get_distance(atom_align[i].res1,close_atoms1[atom_align[i].res1][k]) << "  "
								//<< "res2: " << atom_align[i].res2 << " " << close_atoms2[atom_align[i].res2][j] << " " << pdb2.get_distance(atom_align[i].res2,close_atoms2[atom_align[i].res2][j]);
							}
							break;
						}
					}
				}
				//cout << endl;
			}
		}
		
  }
  
  return;
}

void modify_sigmas(vector<residue_alignment> &restraints1, vector<residue_alignment> &restraints2, vector<double> &sigmas, bool BFAC1, bool BFAC2)
{
	for(unsigned int i=0; i<restraints1.size(); i++){
		if(BFAC1 == 1){
			sigmas[i] = sigmas[i]*restraints1[i].bfac/10.0;
		}
		if(BFAC2 == 1){
			sigmas[i] = sigmas[i]*restraints2[i].bfac/10.0;
		}
	}
	cout << endl << "Sigmas scaled by average bfactors of restrained atom-pairs";
	if(BFAC1 == 1){
		if(BFAC2 == 1){
			cout << " (target and reference)";
		}
		cout << " (target only)";
	} else if(BFAC2 == 1){
		cout << " (reference only)";
	}
	cout << "."	<< endl;	
	return;
}

//#define EXTRA_RESTRAINTS_INFO
void write_restraints(vector<string> &info, string file, vector<residue_alignment> &restraints1, vector<residue_alignment> &restraints2, PDBfile &pdb0, vector<double> &sigmas, vector<res_corresp> &original_res1, PDBfile &pdb2, vector<res_corresp> &original_res2, int TYPE)
{
  pdbline temp1;
  pdbline temp2;
    
    pdbline temp3;
    pdbline temp4;
    
  ofstream outfile;
  outfile.open(file.c_str());
    if(outfile.is_open()){
        outfile << "# ProSMART Restraints File\n";
		for(unsigned int i=0; i<info.size(); i++){
			outfile << info[i] << endl;
		}
       outfile << "external generated ProSMART source " << get_filename(file) << endl;
        for(unsigned int i=0; i<restraints1.size(); i++){	  
            temp1 = pdb0.line(restraints1[i].res1);
            temp2 = pdb0.line(restraints1[i].res2);
            if(temp1.alt != ' ' || temp2.alt != ' '){
                continue;
            }
            temp3 = pdb2.line(restraints2[i].res1);
            temp4 = pdb2.line(restraints2[i].res2);
            if(temp3.alt != ' ' || temp4.alt != ' '){
                continue;
            }
            
			outfile << "exte dist first chain " << temp1.chain 
			<< " resi " << original_res1[temp1.res_num].res
			<< " ins ";
			if(original_res1[temp1.res_num].ins != ' '){
				outfile << original_res1[temp1.res_num].ins;
			} else {
				outfile << ".";
			}
            outfile << " atom " << temp1.atom;
            if(temp1.alt != ' '){
				outfile << " altc " << temp1.alt;
			}
			outfile << " second chain " << temp2.chain 
			<< " resi " << original_res1[temp2.res_num].res
			<< " ins ";
			if(original_res1[temp2.res_num].ins != ' '){
				outfile << original_res1[temp2.res_num].ins;
			} else {
				outfile << ".";
			}
			outfile << " atom " << temp2.atom;
            if(temp2.alt != ' '){
				outfile << " altc " << temp2.alt;
			}
			outfile << " value " << restraints2[i].dist 
			<< " sigma " << sigmas[i];
            
            if(TYPE>=0){
                outfile << " type " << TYPE;
            }
            
            outfile << endl;
            
#ifdef EXTRA_RESTRAINTS_INFO
            outfile << "  #original dist: " << restraints1[i].dist << endl;
            outfile << "  #reference: " 
			<< " resi " << original_res2[temp3.res_num].res
			<< " ins ";
			if(original_res2[temp3.res_num].ins != ' '){
				outfile << original_res2[temp3.res_num].ins;
			} else {
				outfile << ".";
			}
            outfile << " atom " << temp3.atom;
            if(temp3.alt != ' '){
				outfile << " altc " << temp3.alt;
			}
			outfile << " second chain " << temp2.chain 
			<< " resi " << original_res2[temp4.res_num].res
			<< " ins ";
			if(original_res2[temp4.res_num].ins != ' '){
				outfile << original_res2[temp4.res_num].ins;
			} else {
				outfile << ".";
			}
			outfile << " atom " << temp4.atom;
            if(temp4.alt != ' '){
				outfile << " altc " << temp4.alt;
			}
            outfile << " dist: " << restraints2[i].dist << endl;
            outfile << endl;
#endif
        }
		outfile.close();
		cout << endl << "Restraints file written to: " << file;
    } else {
        cout << "Unable to open output file " << file << " for writing" << endl;
    }
	
  return;
}

void write_interatomic_distances(string &file, string &obj1, PDBfile &pdb1, vector<res_corresp> &original_res1, vector<vector<int> > &close_atoms_hbond)
//creates PyMOL script to display restraints
{
    string tmp1;
    string tmp2;
    ofstream outfile;
    outfile.open(file.c_str());
    if(outfile.is_open()){
        for(unsigned int i=0; i<close_atoms_hbond.size(); i++){
            tmp1 = delete_spaces(obj1 + "///" + int_to_str(original_res1[pdb1.get_resnum(i)].res) + original_res1[pdb1.get_resnum(i)].ins + "/" + pdb1.get_atom(i));
            for(unsigned int j=0; j<close_atoms_hbond[i].size(); j++){
                tmp2 = delete_spaces(obj1 + "///" + int_to_str(original_res1[pdb1.get_resnum(close_atoms_hbond[i][j])].res) + original_res1[pdb1.get_resnum(close_atoms_hbond[i][j])].ins + "/" + pdb1.get_atom(close_atoms_hbond[i][j]));
                outfile << "dist /" << tmp1 << ", /" << tmp2 << endl;
            }
        }
        outfile << "hide labels" << endl;
        outfile << "set dash_gap, 0.1" << endl;
        outfile << "set dash_color, red" << endl;
        outfile << "set dash_width, 4" << endl;
		outfile.close();
		cout << endl << "PyMOL interatomic distances file written to: " << file << endl;
    } else {
        cout << "Unable to open output file " << file << " for writing" << endl;
    }
	
    return;
}

void write_no_restraints_per_atom(string &file, string &obj1, PDBfile &pdb1, vector<res_corresp> &original_res1, vector<vector<int> > &close_atoms)
//creates PyMOL script to colour atoms
{
    vector<int> scores;
    //number of restraints per atom:
    for(unsigned int i=0; i<close_atoms.size(); i++){
        scores.push_back(0);
    }
    for(unsigned int i=0; i<close_atoms.size(); i++){
        for(unsigned int j=0; j<close_atoms[i].size(); j++){
            scores[i]++;
            scores[close_atoms[i][j]]++;
        }
    }
    
    ofstream outfile;
    outfile.open(file.c_str());
    if(outfile.is_open()){
        outfile << "# ProSMART Colour File" << endl;
        outfile << "# colour key:" << endl;
        outfile << "# red - atom has one restraint" << endl;
        outfile << "# blue - atom has two restaints" << endl;
        outfile << "# green - atom has more than two restraints" << endl;
        outfile << "# white - residue has no restrained atoms" << endl;
        outfile << "hide everything" << endl;
        outfile << "show dashes" << endl;
        outfile << "show sticks, (n;N,C,CA,O)" << endl;
        outfile << "color white, (" << obj1 << "///*/*)" << endl;
        
        for(unsigned int i=0; i<scores.size(); i++){
            switch(scores[i]){
                case 0: continue;
                case 1: outfile << "color red";break;
                case 2: outfile << "color blue";break;
                default: outfile << "color green";break;
            }
            outfile << ", (" << obj1 << "///" << int_to_str(original_res1[pdb1.get_resnum(i)].res);
            if(original_res1[pdb1.get_resnum(i)].ins != ' '){
                outfile << original_res1[pdb1.get_resnum(i)].ins; 
            }
            outfile << "/" << delete_spaces(pdb1.get_atom(i)) << ")" << endl;
        }
        
        outfile.close();
		cout << endl << "Colour script written to: " << file;
    } else {
        cout << "Unable to open output file " << file << " for writing" << endl;
    }
    
    return;
}

void write_residue_separation(string &file, string &obj1, PDBfile &pdb1, vector<res_corresp> &original_res1, vector<vector<int> > &close_atoms)
//creates PyMOL script to colour atoms
{
    vector<int> scores;
    for(unsigned int i=0; i<close_atoms.size(); i++){
        for(unsigned int j=0; j<close_atoms[i].size(); j++){
            unsigned int r1 = pdb1.get_resnum(i);
            unsigned int r2 = pdb1.get_resnum(close_atoms[i][j]);
            while(scores.size()<=r1 || scores.size()<=r2){
                scores.push_back(0);
            }
            int diff_dist = r2-r1;
            if(scores[r1]==0 || scores[r1]>diff_dist)scores[r1] = diff_dist;
            if(scores[r2]==0 || scores[r2]>diff_dist)scores[r2] = diff_dist;
        }
    }
    
    ofstream outfile;
    outfile.open(file.c_str());
    if(outfile.is_open()){
        outfile << "# ProSMART Colour File" << endl;
        outfile << "# colour key (in order of priority):" << endl;
        outfile << "# red - includes restrained atoms separated by less than 3 residues" << endl;
        outfile << "# aquamarine - includes restrained atoms separated by exactly 3 residues (e.g. 3_10 helix)" << endl;
        outfile << "# tv_blue - includes restrained atoms separated by exactly 4 residues (e.g. alpha helix)" << endl;
        outfile << "# orange - includes restrained atoms separated by exactly 5 residues (e.g. pi helix)" << endl;
        outfile << "# yellow - includes restrained atoms separated by more than 5 residues (e.g. beta sheet)" << endl;
        outfile << "# white - residue has no restrained atoms" << endl;
        outfile << "hide everything" << endl;
        outfile << "show dashes" << endl;
        outfile << "show sticks, (n;N,C,CA,O)" << endl;
        outfile << "show cartoon" << endl;
        outfile << "color white, (" << obj1 << "///*/*)" << endl;
        
        for(unsigned int i=0; i<scores.size(); i++){
            if(scores[i]==0)continue;
            else if(scores[i]<3) outfile << "color red";
            else if(scores[i]==3) outfile << "color aquamarine";
            else if(scores[i]==4) outfile << "color tv_blue";
            else if(scores[i]==5) outfile << "color orange";
            else if(scores[i]>5) outfile << "color yellow";
            outfile << ", (" << obj1 << "///" << int_to_str(original_res1[i].res);
            if(original_res1[i].ins != ' '){
				outfile << original_res1[i].ins; 
			}
            outfile << "/*)" << endl;
        }

        outfile.close();
		cout << endl << "Colour script written to: " << file;
    } else {
        cout << "Unable to open output file " << file << " for writing" << endl;
    }

    return;
}

void write_restraints_hbond(vector<string> &info, string file, PDBfile &pdb0, vector<res_corresp> &original_res1, vector<vector<int> > &close_atoms_hbond, double target_dist, double sigma, int TYPE)
//generic restraints that restrain towards fixed value (e.g. ideal h-bond distance).
//does not restrain alternative conformations
{
    pdbline temp1;
    pdbline temp2;
    
    ofstream outfile;
    outfile.open(file.c_str());
    if(outfile.is_open()){
        outfile << "# ProSMART Restraints File" << endl;
		for(unsigned int i=0; i<info.size(); i++){
			outfile << info[i] << endl;
		}
       outfile << "external generated ProSMART source GenericBond\n";
        for(unsigned int i=0; i<close_atoms_hbond.size(); i++){
            temp1 = pdb0.line(i);
            for(unsigned int j=0; j<close_atoms_hbond[i].size(); j++){
                temp2 = pdb0.line(close_atoms_hbond[i][j]);
                if(temp1.alt != ' ' || temp2.alt != ' '){
                    continue;
                }
                
                outfile << "exte dist first chain " << temp1.chain 
                << " resi " << original_res1[temp1.res_num].res
                << " ins ";
                if(original_res1[temp1.res_num].ins != ' '){
                    outfile << original_res1[temp1.res_num].ins;
                } else {
                    outfile << ".";
                }
                outfile << " atom " << temp1.atom;
                if(temp1.alt != ' '){
                    outfile << " altc " << temp1.alt;
                }
                outfile << " second chain " << temp2.chain 
                << " resi " << original_res1[temp2.res_num].res
                << " ins ";
                if(original_res1[temp2.res_num].ins != ' '){
                    outfile << original_res1[temp2.res_num].ins;
                } else {
                    outfile << ".";
                }
                outfile << " atom " << temp2.atom;
                if(temp2.alt != ' '){
                    outfile << " altc " << temp2.alt;
                }
                outfile << " value " << target_dist 
                << " sigma " << sigma;
                
                if(TYPE>=0){
                    outfile << " type " << TYPE;
                }
                
                outfile << endl;
            }
        }
		outfile.close();
		cout << endl << "Restraints file written to: " << file << endl;
    } else {
        cout << "Unable to open output file " << file << " for writing" << endl;
    }
	
    return;
}


void filter_restraints(vector<residue_alignment> &restraints1,vector<residue_alignment> &restraints2, vector<double> &diff_dist, PDBfile &pdb1, PDBfile &pdb2)
{
  vector<double> result;
  pdbline temp1;
  pdbline temp2;
  pdbline temp3;
  pdbline temp4;
  coord crd1;
  coord crd2;
  PDBfile pdb1main;
  PDBfile pdb2main;
  
  pdb1.mainchain(pdb1main);		//only want to use the mainchain for calculating average residue positions.
  pdb2.mainchain(pdb2main);
  vector<coord> av_pos1 = pdb1main.av_pos();	//calculate average residue positions
  vector<coord> av_pos2 = pdb2main.av_pos();
  
  //construct arrays to store results for residues.
  //2D array is all that is needed, but a 3D array is used so that 'empty' can imply 'not calculated yet'.
  vector<vector<vector<double> > > dd;
  vector<vector<double> > dd0;
  vector<double> dd00;
  dd00.clear();
  for(unsigned int i=0; i<av_pos1.size(); i++){dd0.push_back(dd00);}
  for(unsigned int i=0; i<av_pos1.size(); i++){dd.push_back(dd0);}
  
  for(unsigned int i=0; i<restraints1.size(); i++){	//for each atom-pair
    temp1 = pdb1.line(restraints1[i].res1);
		temp2 = pdb1.line(restraints1[i].res2);
		if(dd[temp1.res_num][temp2.res_num].empty()){	//if this residue-pair hasn't been considered yet
			temp3 = pdb2.line(restraints2[i].res1);
      temp4 = pdb2.line(restraints2[i].res2);
			crd1 = av_pos1[temp1.res_num]-av_pos1[temp2.res_num];
			crd2 = av_pos2[temp3.res_num]-av_pos2[temp4.res_num];
			dd[temp1.res_num][temp2.res_num].push_back(abs(dist(crd1)-dist(crd2)));	//diff between distances for residue-pair
		}
		result.push_back(dd[temp1.res_num][temp2.res_num][0]*((2*(rand()%2))-1));	//get differences between distances for atoms, and symmetrize
  }
	
  diff_dist.clear();
  for(unsigned int i=0; i<restraints1.size(); i++){
    diff_dist.push_back(result[i]);
  }
  return;
}

void filter_bonded_atoms(string filein_bonds, char chain, vector<res_corresp> &rename, vector<residue_alignment> &res1, vector<residue_alignment> &res2, PDBfile &pdb1, int MAX_RESNUM)
{
  pdbline temp1;
  pdbline temp2;
  int start_idx=0;
  int idx=0;
  bool found;
  string temp;
  vector<vector<string> > bonded = file_read_bonds(filein_bonds,chain,MAX_RESNUM);
  
  cout << endl << "bonds: " << bonded.size() << endl;
  //cout << endl << "res1: " << res1.size() << endl;
  //cout << endl << "res2: " << res2.size() << endl;
  
  if(bonded.size()>0){
		/*
		 for(unsigned int i=0; i<10; i++){
		 cout << endl;
		 for(unsigned int j=0; j<bonded[i].size(); j++){
		 cout << bonded[i][j] << " ";
		 }
		 }
		 */
		for(unsigned int i=0; i<res1.size(); i++){
			temp1 = pdb1.line(res1[i].res1);	//get restraint info
			temp2 = pdb1.line(res1[i].res2);
			//cout << endl << rename[temp1.res_num].res << " " << temp1.atom << " " << temp1.resid << " " << temp1.ins_code;
			//cout << "\t" << rename[temp2.res_num].res << " " << temp2.atom << " " << temp2.resid << " " << temp2.ins_code;
			
			if(rename[temp1.res_num].res > str_to_int(bonded[start_idx][1])){
				start_idx=idx;	//this reduces the required amount of computation
			} else {
				idx=start_idx;
			}
			
			found=0;	//search for matches between the bonded atoms and the restraints
			while(str_to_int(bonded[idx][1])<=rename[temp1.res_num].res && found==0){
				/*
				 cout << endl << endl << "\tidx: " << idx;
				 cout << endl << "\tatom1 " << delete_spaces(bonded[idx][3]) << " " << delete_spaces(temp1.atom);
				 cout << endl << "\tatom2 " << delete_spaces(bonded[idx][7]) << " " << delete_spaces(temp2.atom);
				 cout << endl << "\tnum1  " << str_to_int(bonded[idx][1]) << " " << rename[temp1.res_num].res;
				 cout << endl << "\tnum2  " << str_to_int(bonded[idx][5]) << " " << rename[temp2.res_num].res;
				 cout << endl << "\tins1  " << bonded[idx][2] << " " << temp1.ins_code << "\t";
				 if(bonded[idx][2] == "."){cout << "' '";}else{cout << bonded[idx][2];} cout << ":";
				 if(temp1.ins_code == ' '){cout << "' '";}else{cout << temp1.ins_code;}
				 if( (bonded[idx][2] == "." && temp1.ins_code == ' ') || bonded[idx][2][0] == temp1.ins_code){cout << " same!";}
				 cout << endl << "\tins2  " << bonded[idx][6] << " " << temp2.ins_code << "\t";
				 if(bonded[idx][6] == "."){cout << "' '";}else{cout << bonded[idx][6];} cout << ":";
				 if(temp2.ins_code == ' '){cout << "' '";}else{cout << temp2.ins_code;}
				 if( (bonded[idx][6] == "." && temp2.ins_code == ' ') || bonded[idx][6][0] == temp2.ins_code){cout << " same!";}
				 */
				
				temp = delete_spaces(temp1.atom);
				if(delete_spaces(bonded[idx][3])==delete_spaces(temp) && str_to_int(bonded[idx][1])==rename[temp1.res_num].res){
					temp = delete_spaces(temp2.atom);
					if(delete_spaces(bonded[idx][7])==delete_spaces(temp) && str_to_int(bonded[idx][5])==rename[temp2.res_num].res){
						if( (bonded[idx][2] == "." && temp1.ins_code == ' ') || (bonded[idx][2][0] == temp1.ins_code) ){
							if( (bonded[idx][6] == "." && temp2.ins_code == ' ') || (bonded[idx][6][0] == temp2.ins_code) ){
								//cout << " *** ";
								found=1;
							}}}}
				
				if(found==0){
					temp = delete_spaces(temp2.atom);
					if(delete_spaces(bonded[idx][3])==delete_spaces(temp) && str_to_int(bonded[idx][1])==rename[temp2.res_num].res){
						temp = delete_spaces(temp1.atom);
						if(delete_spaces(bonded[idx][7])==delete_spaces(temp) && str_to_int(bonded[idx][5])==rename[temp1.res_num].res){
							if( (bonded[idx][2] == "." && temp2.ins_code == ' ') || (bonded[idx][2][0] == temp2.ins_code) ){
								if( (bonded[idx][6] == "." && temp1.ins_code == ' ') || (bonded[idx][6][0] == temp1.ins_code) ){
									//cout << " *_* ";
									found=1;
								}}}}}
				
				idx++;
				if(idx>=(int)bonded.size()){	//to stop indexing past the end of the array
					break;
				}
			}
			if(found==1){	//if a match is found, delete the restraint
				res1.erase(res1.begin()+i);
				res2.erase(res2.begin()+i);
				//cout << "!!!";
				i--;
			}
		}
		
		cout << endl << "Restraints corresponding to bonded atom-pairs have been removed.";
		cout << endl << res1.size() << " atomic restraints identified as non-bonded.";
		
  }
	
  return;
}

void write_diff(string file, vector<residue_alignment> &restraints1, vector<residue_alignment> &restraints2, PDBfile &pdb1, PDBfile &pdb2, vector<double> &res_scores1, vector<double> &res_scores2, vector<double> &diff_dist, vector<res_corresp> &rename)
{
  pdbline temp1;
  pdbline temp2;
  pdbline temp3;
  pdbline temp4;
  
  ofstream outfile;
  outfile.open(file.c_str());
  if(outfile.is_open()){
    outfile << "dist1" << "\t"
		<< "resnum1" << "\t"
		<< "atom1" << "\t"
		<< "ins1" << "\t"
		<< "B_orig" << "\t"
		<< "score1" << "\t"
		<< "dist2" << "\t"
		<< "resnum2" << "\t"
		<< "atom2" << "\t"
		<< "ins2" << "\t"
		<< "B_rest" << "\t"
		<< "score2" << "\t"
		<< "diff" << "\t"
		<< "type"
		<< endl;
    for(unsigned int i=0; i<restraints1.size(); i++){
			temp1 = pdb1.line(restraints1[i].res1);
      temp2 = pdb1.line(restraints1[i].res2);
			temp3 = pdb2.line(restraints2[i].res1);
      temp4 = pdb2.line(restraints2[i].res2);
			
			outfile << restraints1[i].dist << "\t" 
			<< rename[temp1.res_num].res << "\t"
			<< temp1.atom << "\t";
			if(temp1.ins_code==' '){outfile << ".\t";}else{outfile << temp1.ins_code << "\t";}
			outfile << temp1.bfact + temp2.bfact << "\t"
			<< res_scores1[temp1.res_num] << "\t"
			<< restraints2[i].dist << "\t"
			<< rename[temp2.res_num].res << "\t"
			<< temp2.atom << "\t";
			if(temp2.ins_code==' '){outfile << ".\t";}else{outfile << temp2.ins_code << "\t";}
			outfile << temp3.bfact + temp4.bfact << "\t"
			<< res_scores2[temp2.res_num] << "\t"
			<< temp2.res_num-temp1.res_num << "\t"
			<< "\"" << temp1.atom << temp2.atom << "\""
			<< endl;
			
		}
		outfile.close();
		cout << endl << "Info file written to: " << file.c_str();
  } else {
    cout << "Unable to open output file " << file.c_str() << " for writing" << endl;
  }
	
  return;
}

vector<double> get_res_scores(vector<residue_alignment> &res_align, int idx)
{
  vector<double> temp;
	
  if(idx==1){
    for(unsigned int i=0; i<res_align.size(); i++){
      if((int)temp.size()==res_align[i].res1){
				temp.push_back(res_align[i].dist);
			} else {
				if((int)temp.size()>res_align[i].res1){		
					continue;		//potential fault with alignment - sequence order not preserved
				}
				temp.push_back(-1.0);
				i--;
			}
    }
  } else {
    for(unsigned int i=0; i<res_align.size(); i++){
      if((int)temp.size()==res_align[i].res2){
				temp.push_back(res_align[i].dist);
			} else {
				if((int)temp.size()>res_align[i].res2){
					continue;		//used for repetitive structure restraints
				}
				temp.push_back(-1.0);
				i--;
			}
    }
  }
  return temp;
}

void get_helix_restraints(vector<residue_alignment> &res_align_original, PDBfile &pdb1, PDBfile &pdb2, Residues &res1, Residues &res2, vector<residue_alignment> &restraints1, vector<residue_alignment> &restraints2, double MIN_DISTANCE, double dist_param, string &filein, vector<res_corresp> &original_res1, vector<int> &RANGE_MIN, vector<int> &RANGE_MAX, vector<string> &RM_RESIDUES)
{
	vector<vector<int> > align_mat = read_file_lines_int(filein);
	if(align_mat.size()>0){
		cout << endl << "Successfully read file: " << filein << endl;
	} else {
		cout << "Unable to open " << filein << " for reading" << endl; 
	}

    /*for(unsigned int i=0; i<align_mat.size(); i++){
        cout << endl;
        for(unsigned int j=0; j<align_mat[i].size(); j++){
            cout << align_mat[i][j] << "\t";
        }
    }
    cout << endl;*/
	
	/*for(unsigned int i=0; i<res_align_original.size(); i++){
    cout << endl << i << "\t" << res_align_original[i].res1 << "\t" << res_align_original[i].dist;
	}*/
	
	vector<vector<int> > res_restraints;
	vector<int> temp_v;
	vector<int> temp_v2;
	vector<int> temp_atoms1;
	vector<int> temp_atoms2;
	vector<int> temp_atoms3;
	vector<int> temp_atoms4;
	residue_alignment rest1;
	residue_alignment rest2;
    bool VALID;
    string tmp_str;

	for(unsigned int i=0; i<align_mat.size(); i++){
		for(unsigned int j=0; j<align_mat[i].size(); j++){
			temp_v.clear();
			temp_v.push_back(res_align_original[i].res1);
			temp_v.push_back(res_align_original[i+j].res1);
			temp_v.push_back(align_mat[i][j]);
			temp_v.push_back(align_mat[i][j]+j);
			res_restraints.push_back(temp_v);
		}
	}
	for(unsigned int i=0; i<res_restraints.size(); i++){
		/*cout << endl;
		 for(unsigned int j=0; j<4; j++){
		 cout << res_restraints[i][j] << " ";
		 }
		 cout << endl;*/
		
		temp_v = res1.get_atoms(res_restraints[i][0]);
		temp_v2 = res2.get_atoms(res_restraints[i][2]);
		temp_atoms1.clear();
		temp_atoms2.clear();
		for(unsigned int j=0; j<temp_v.size(); j++){
			for(unsigned int k=0; k<temp_v2.size(); k++){
				if(pdb1.get_atom(temp_v[j])==pdb2.get_atom(temp_v2[k])){
					temp_atoms1.push_back(temp_v[j]);
					temp_atoms2.push_back(temp_v2[k]);
					temp_v2.erase(temp_v2.begin()+k);
					break;
				}
			}
		}
		/*for(unsigned int j=0; j<temp_atoms1.size(); j++){
		 cout << "\t" << temp_atoms1[j] << "\t" << pdb1.get_atom(temp_atoms1[j])
		 << "\t" << temp_atoms2[j] << "\t" << pdb2.get_atom(temp_atoms2[j]) << endl;
		 }
		 cout << endl;*/
		
		temp_v = res1.get_atoms(res_restraints[i][1]);
		temp_v2 = res2.get_atoms(res_restraints[i][3]);
		temp_atoms3.clear();
		temp_atoms4.clear();
		for(unsigned int j=0; j<temp_v.size(); j++){
			for(unsigned int k=0; k<temp_v2.size(); k++){
				if(pdb1.get_atom(temp_v[j])==pdb2.get_atom(temp_v2[k])){
					temp_atoms3.push_back(temp_v[j]);
					temp_atoms4.push_back(temp_v2[k]);
					temp_v2.erase(temp_v2.begin()+k);
					break;
				}
			}
		}
		
        /*for(unsigned int j=0; j<temp_atoms3.size(); j++){
            cout << "\t" << temp_atoms3[j] << "\t" << pdb1.get_atom(temp_atoms3[j])
            << "\t" << pdb1.get_resnum(temp_atoms3[j])
            << "\t" << original_res1[pdb1.get_resnum(temp_atoms3[j])] << endl;
            //temp_atoms4[j] << "\t" << pdb2.get_atom(temp_atoms4[j]) << endl;
        }*/
		for(unsigned int j=0; j<temp_atoms1.size(); j++){
			for(unsigned int k=0; k<temp_atoms3.size(); k++){
				if(temp_atoms1[j] >= temp_atoms3[k]){continue;}
                
                //allow filtering custom residue range
                if(RANGE_MIN.size()>0){
                    VALID=0;
                    for(unsigned int l=0; l<RANGE_MIN.size(); l++){
                        if(original_res1[pdb1.get_resnum(temp_atoms1[j])].res >= RANGE_MIN[l] && original_res1[pdb1.get_resnum(temp_atoms3[k])].res >= RANGE_MIN[l]){
                            if(original_res1[pdb1.get_resnum(temp_atoms1[j])].res <= RANGE_MAX[l] && original_res1[pdb1.get_resnum(temp_atoms3[k])].res <= RANGE_MAX[l]){
                                VALID=1;
                                break;
                            }
                        }
                    }
                    if(VALID==0){
                        continue;
                    }
                }
                if(RM_RESIDUES.size()>0){
                    VALID=1;
                    for(unsigned int l=0; l<RM_RESIDUES.size(); l++){
                        if(original_res1[pdb1.get_resnum(temp_atoms1[j])].ins == ' '){
                            tmp_str = int_to_str(original_res1[pdb1.get_resnum(temp_atoms1[j])].res);
                        } else {
                            tmp_str = int_to_str(original_res1[pdb1.get_resnum(temp_atoms1[j])].res) + original_res1[pdb1.get_resnum(temp_atoms1[j])].ins;
                        }
                        //cout << endl << "'" << tmp_str << "'" << RM_RESIDUES[l] << "'";
                        if(tmp_str == RM_RESIDUES[l]){
                            VALID = 0;
                            break;
                        }
                        if(original_res1[pdb1.get_resnum(temp_atoms3[k])].ins == ' '){
                            tmp_str = int_to_str(original_res1[pdb1.get_resnum(temp_atoms3[k])].res);
                        } else {
                            tmp_str = int_to_str(original_res1[pdb1.get_resnum(temp_atoms3[k])].res) + original_res1[pdb1.get_resnum(temp_atoms3[k])].ins;
                        }
                        //cout << endl << "'" << tmp_str << "'" << RM_RESIDUES[l] << "'";
                        if(tmp_str == RM_RESIDUES[l]){
                            VALID = 0;
                            break;
                        }
                    }
                    if(VALID==0){
                        continue;
                    }
                }
                /*cout << "\t" << temp_atoms1[j] << "\t" << pdb1.get_atom(temp_atoms1[j])
                << "\t" << pdb1.get_resnum(temp_atoms1[j])
                << "\t" << original_res1[pdb1.get_resnum(temp_atoms1[j])]
                << "\t" << temp_atoms3[k] << "\t" << pdb1.get_atom(temp_atoms3[k])
                << "\t" << pdb1.get_resnum(temp_atoms3[k])
                << "\t" << original_res1[pdb1.get_resnum(temp_atoms3[k])]<< endl;*/
                
				rest1.dist = pdb1.get_distance(temp_atoms1[j],temp_atoms3[k]);
				if(rest1.dist >= MIN_DISTANCE && rest1.dist <= dist_param){
					temp_v.clear();
					rest1.res1 = temp_atoms1[j];
					rest1.res2 = temp_atoms3[k];
					rest2.res1 = temp_atoms2[j];
					rest2.res2 = temp_atoms4[k];
					rest2.dist = pdb2.get_distance(temp_atoms2[j],temp_atoms4[k]);
					rest2.bfac = pdb2.get_av_bfact(rest2.res1,rest2.res2);		//only interested in bfactors of external structure
					rest1.bfac = rest2.bfac;
					restraints1.push_back(rest1);
					restraints2.push_back(rest2);
				}
			}
		}
	}
	/*for(unsigned int i=0; i<restraints1.size(); i++){
	 cout << endl 
	 << "\t" << restraints1[i].res1
	 << "\t" << restraints1[i].res2
	 << "\t" << restraints1[i].dist
	 << "\t" << restraints2[i].res1
	 << "\t" << restraints2[i].res2
	 << "\t" << restraints2[i].dist;
	 }
	 cout << endl;*/
	
	return;
}




