//
// This file is part of ProSMART.
//

#ifndef restrain_atomic_restraints_H
#define restrain_atomic_restraints_H

#include "restrain_align_handler.h"
#include "prosmart_file_management.h"


void get_atom_restraints(vector<residue_alignment> &, vector<residue_alignment> &, vector<residue_alignment> &, vector<vector<int> > &, vector<vector<int> > &, Array1D<int> &, PDBfile &, PDBfile &, double, int HELIX);
void modify_sigmas(vector<residue_alignment> &, vector<residue_alignment> &, vector<double> &,bool,bool);
void write_restraints(vector<string> &, string, vector<residue_alignment> &, vector<residue_alignment> &, PDBfile &, vector<double> &, vector<res_corresp> &, PDBfile &, vector<res_corresp> &, int);
void write_restraints_hbond(vector<string> &, string, PDBfile &, vector<res_corresp> &, vector<vector<int> > &, double, double, int);
void write_interatomic_distances(string &, string &, PDBfile &, vector<res_corresp> &, vector<vector<int> > &);
void write_no_restraints_per_atom(string &, string &, PDBfile &, vector<res_corresp> &, vector<vector<int> > &);
void write_residue_separation(string &, string &, PDBfile &, vector<res_corresp> &, vector<vector<int> > &);
void write_diff(string, vector<residue_alignment> &, vector<residue_alignment> &, PDBfile &, PDBfile &, vector<double> &, vector<double> &, vector<double> &, vector<res_corresp> &);
vector<string> info_vector(string, string, char, char, int, int, double, double, double, int, string, double, double, double, double);
vector<double> get_res_scores(vector<residue_alignment> &, int);
void filter_restraints(vector<residue_alignment> &,vector<residue_alignment> &, vector<double> &, PDBfile &, PDBfile &);
void filter_bonded_atoms(string, char, vector<res_corresp> &, vector<residue_alignment> &, vector<residue_alignment> &, PDBfile &, int);
void get_helix_restraints(vector<residue_alignment> &, PDBfile &, PDBfile &, Residues &, Residues &, vector<residue_alignment> &, vector<residue_alignment> &, double, double, string &, vector<res_corresp> &, vector<int> &, vector<int> &, vector<string> &);

#endif
