//
// This file is part of ProSMART.
//

#ifndef restrain_boxing_algorithm_H
#define restrain_boxing_algorithm_H

#include "prosmart_file_management.h"
#include "prosmartClass_PDBfile.h"

vector<coord> get_outer_box(PDBfile&);
vector<vector<vector<vector<int> > > > get_boxed_atoms(PDBfile&, vector<coord>, double);
Array1D<coord> get_atom_boxes(vector<vector<vector<vector<int> > > > &, int);
vector<vector<vector<vector<int> > > > get_adjacent_atoms_array(vector<vector<vector<vector<int> > > > &);
vector<int> get_adjacent_atoms(coord &, vector<vector<vector<vector<int> > > > &);
vector<int> get_close_atoms(int, Array1D<coord> &, vector<vector<vector<vector<int> > > > &, PDBfile &, double);

#endif
