//
// This file is part of ProSMART.
//

#ifndef restrain_vector_operations_H
#define restrain_vector_operations_H

#include "jama_lu.h"
#include "prosmart_array_tools.h"

vector<vector<double> > identity(int);
vector<vector<double> > diag(vector<double>);
double mod(vector<double> &);

vector<double> s_prod(double, vector<double> &);
vector<double> v_prod(vector<vector<double> > &, vector<double> &);
double v_prod(vector<double> &, vector<double> &);
vector<vector<double> > v_prod_T(vector<double> &, vector<double> &);
vector<double> v_add(vector<double> &, vector<double>);
vector<double> v_negative(vector<double>);
vector<double> v_subtract(vector<double> &, vector<double> &);
vector<vector<double> > M_add(vector<vector<double> > &, vector<vector<double> > &);
vector<vector<double> > M_mult(double, vector<vector<double> > &);
vector<vector<double> > M_subtract(vector<vector<double> > &, vector<vector<double> > &);
vector<vector<double> > crossprod(vector<vector<double> > &, vector<vector<double> > &);
void M_view(vector<vector<double> > &);

int get_inverse(vector<vector<double> > &, vector<vector<double> > &);
int get_inverse(Array2D<double> &, Array2D<double> &);
Array2D<double> convert_array(vector<vector<double> > &);
vector<vector<double> > convert_array(Array2D<double> &);

double sd(vector<double> &);
double var(vector<double> &);

#endif
