TITL cubic insulin refinement
CELL  1.54178   77.726   77.726   77.726  90.00  90.00  90.00
ZERR       24    0.078    0.078    0.078   0.00   0.00   0.00
 
REM Space group I 2(1) 3
 
LATT -2
SYMM 1/2-X, -Y, 1/2+Z
SYMM -X, 1/2+Y, 1/2-Z
SYMM 1/2+X, 1/2-Y, -Z
SYMM Z, X, Y
SYMM 1/2+Z, 1/2-X, -Y
SYMM 1/2-Z, -X, 1/2+Y
SYMM -Z, 1/2+X, 1/2-Y
SYMM Y, Z, X
SYMM -Y, 1/2+Z, 1/2-X
SYMM 1/2+Y, 1/2-Z, -X
SYMM 1/2-Y, -Z, 1/2+X
SFAC  C  H  N  O  S
UNIT  6096 11352 1560 1800 144
 
DEFS 0.02 0.1 0.01 0.04
CGLS 10 -1
SHEL 10 0.1
FMAP 2
PLAN 200 2.3
LIST 6
WPDB 2
 
DELU $C_* $N_* $O_* $S_*
SIMU 0.1 $C_* $N_* $O_* $S_*
ISOR 0.1 O_3001 > LAST
CONN 0 O_3001 > LAST
BUMP
REM HOPE
 
REM Remove MERG 4 instruction if Friedel opposites should not be merged
 
MERG 4
 
REM MORE 0 would reduce output if not required for diagnostic purposes
 
REM MORE 0
 
REM Remove 'REM ' before RTAB to activate remaining tables
 
RTAB_* Cvol CA
RTAB_* Omeg CA_+ N_+ C CA
RTAB_* Phi C_- N CA C
RTAB_* Psi N CA C N_+
RTAB_ARG Chi1 N CA CB CG
RTAB_ARG Chi2 CA CB CG CD
RTAB_ARG Chi3 CB CG CD NE
RTAB_ARG Chi4 CG CD NE CZ
RTAB_ASN Chi1 N CA CB CG
RTAB_ASN Chi2 CA CB CG OD1
RTAB_CYS Chi1 N CA CB SG
RTAB_GLN Chi1 N CA CB CG
RTAB_GLN Chi2 CA CB CG CD
RTAB_GLN Chi3 CB CG CD OE1
RTAB_GLU Chi1 N CA CB CG
RTAB_GLU Chi2 CA CB CG CD
RTAB_GLU Chi3 CB CG CD OE1
RTAB_HIS Chi1 N CA CB CG
RTAB_HIS Chi2 CA CB CG ND1
RTAB_ILE Chi1 N CA CB CG1
RTAB_ILE Chi2 CA CB CG1 CD1
RTAB_ILE Cvol CB
RTAB_LEU Chi1 N CA CB CG
RTAB_LEU Chi2 CA CB CG CD1
RTAB_LYS Chi1 N CA CB CG
RTAB_LYS Chi2 CA CB CG CD
RTAB_LYS Chi3 CB CG CD CE
RTAB_LYS Chi4 CG CD CE NZ
RTAB_PHE Chi1 N CA CB CG
RTAB_PHE Chi2 CA CB CG CD1
RTAB_PRO Chi1 N CA CB CG
RTAB_PRO Chi2 CA CB CG CD
RTAB_PRO Chi3 CB CG CD N
RTAB_SER Chi1 N CA CB OG
RTAB_THR Chi1 N CA CB OG1
RTAB_THR Cvol CB
RTAB_TYR Chi1 N CA CB CG
RTAB_TYR Chi2 CA CB CG CD1
RTAB_VAL Chi1 N CA CB CG1
 
REM Remove 'REM ' in following to activate H-atom generation
 
REM HFIX 33 N_1001 N_2001
 
REM HFIX_ALA 43 N
REM HFIX_ALA 13 CA
REM HFIX_ALA 33 CB
 
REM HFIX_ARG 13 CA
REM HFIX_ARG 23 CB CG CD
REM HFIX_ARG 43 N NE
REM HFIX_ARG 93 NH1 NH2
 
REM HFIX_ASN 43 N
REM HFIX_ASN 13 CA
REM HFIX_ASN 23 CB
REM HFIX_ASN 93 ND2
 
REM HFIX_CYS 43 N
REM HFIX_CYS 13 CA
REM HFIX_CYS 23 CB
 
REM HFIX_GLN 43 N
REM HFIX_GLN 13 CA
REM HFIX_GLN 23 CB CG
REM HFIX_GLN 93 NE2
 
REM HFIX_GLU 43 N
REM HFIX_GLU 13 CA
REM HFIX_GLU 23 CB CG
 
REM HFIX_GLY 43 N
REM HFIX_GLY 23 CA
 
REM HFIX_HIS 13 CA
REM HFIX_HIS 23 CB
REM HFIX_HIS 43 N ND1 CE1 CD2
 
REM HFIX_ILE 43 N
REM HFIX_ILE 13 CA CB
REM HFIX_ILE 23 CG1
REM HFIX_ILE 33 CD1 CG2
 
REM HFIX_LEU 43 N
REM HFIX_LEU 13 CA CG
REM HFIX_LEU 23 CB
REM HFIX_LEU 33 CD1 CD2
 
REM HFIX_LYS 43 N
REM HFIX_LYS 13 CA
REM HFIX_LYS 23 CB CG CD CE
REM HFIX_LYS 33 NZ
 
REM HFIX_PHE 13 CA
REM HFIX_PHE 23 CB
REM HFIX_PHE 43 N CD1 CD2 CE1 CE2 CZ
 
REM HFIX_PRO 13 CA
REM HFIX_PRO 23 CB CG CD
 
REM HFIX_SER 43 N
REM HFIX_SER 13 CA
REM HFIX_SER 23 CB
REM HFIX_SER 83 OG
 
REM HFIX_THR 43 N
REM HFIX_THR 13 CA CB
REM HFIX_THR 33 CG2
REM HFIX_THR 83 OG1
 
REM HFIX_TYR 13 CA
REM HFIX_TYR 23 CB
REM HFIX_TYR 43 N CD1 CD2 CE1 CE2
REM HFIX_TYR 83 OH
 
REM HFIX_VAL 43 N
REM HFIX_VAL 13 CA CB
REM HFIX_VAL 33 CG1 CG2
 
DFIX_* 1.329 C_- N
DANG_* 2.425 CA_- N
DANG_* 2.250 O_- N
DANG_* 2.435 C_- CA
FLAT_* 0.5 O_- CA_- N C_- CA
 
CHIV_ALA C
CHIV_ALA 2.477 CA
DFIX_ALA 1.231 C O
DFIX_ALA 1.525 C CA
DFIX_ALA 1.521 CA CB
DFIX_ALA 1.458 N CA
DANG_ALA 2.462 C N
DANG_ALA 2.401 O CA
DANG_ALA 2.503 C CB
DANG_ALA 2.446 CB N
 
CHIV_ARG C CZ
CHIV_ARG 2.503 CA
FLAT_ARG CD NH1 NH2 NE CZ
DFIX_ARG 1.231 C O
DFIX_ARG 1.458 CA N
DFIX_ARG 1.525 C CA
DFIX_ARG 1.530 CA CB
DFIX_ARG 1.520 CB CG CG CD
DFIX_ARG 1.460 CD NE
DFIX_ARG 1.326 CZ NE CZ NH1 CZ NH2
DANG_ARG 2.455 N CB
DANG_ARG 2.401 O CA
DANG_ARG 2.504 C CB
DANG_ARG 2.462 C N
DANG_ARG 2.559 CA CG
DANG_ARG 2.510 CB CD
DANG_ARG 2.471 CG NE
DANG_ARG 2.466 CD CZ
DANG_ARG 2.299 NE NH1 NE NH2
DANG_ARG 2.293 NH1 NH2
 
CHIV_ASN C CG
CHIV_ASN 2.503 CA
DFIX_ASN 1.231 C O CG OD1
DFIX_ASN 1.525 C CA
DFIX_ASN 1.458 N CA
DFIX_ASN 1.530 CA CB
DFIX_ASN 1.516 CB CG
DFIX_ASN 1.328 CG ND2
DANG_ASN 2.401 O CA
DANG_ASN 2.462 C N
DANG_ASN 2.455 CB N
DANG_ASN 2.504 C CB
DANG_ASN 2.534 CA CG
DANG_ASN 2.393 CB OD1
DANG_ASN 2.419 CB ND2
DANG_ASN 2.245 OD1 ND2
 
CHIV_CYS C
CHIV_CYS 2.503 CA
DFIX_CYS 1.231 C O
DFIX_CYS 1.525 C CA
DFIX_CYS 1.458 N CA
DFIX_CYS 1.530 CA CB
DFIX_CYS 1.808 CB SG
DANG_CYS 2.401 O CA
DANG_CYS 2.504 C CB
DANG_CYS 2.455 CB N
DANG_CYS 2.462 C N
DANG_CYS 2.810 CA SG
 
CHIV_GLN C CD
CHIV_GLN 2.503 CA
DFIX_GLN 1.231 C O
DFIX_GLN 1.458 N CA
DFIX_GLN 1.525 C CA
DFIX_GLN 1.530 CA CB
DFIX_GLN 1.520 CB CG
DFIX_GLN 1.516 CG CD
DFIX_GLN 1.231 CD OE1
DFIX_GLN 1.328 CD NE2
DANG_GLN 2.401 O CA
DANG_GLN 2.462 C N
DANG_GLN 2.455 CB N
DANG_GLN 2.504 C CB
DANG_GLN 2.559 CA CG
DANG_GLN 2.526 CB CD
DANG_GLN 2.393 CG OE1
DANG_GLN 2.419 CG NE2
DANG_GLN 2.245 OE1 NE2
 
CHIV_GLU C CD
CHIV_GLU 2.503 CA
DFIX_GLU 1.231 C O
DFIX_GLU 1.458 N CA
DFIX_GLU 1.525 C CA
DFIX_GLU 1.530 CA CB
DFIX_GLU 1.520 CB CG
DFIX_GLU 1.516 CG CD
DFIX_GLU 1.249 CD OE1 CD OE2
DANG_GLU 2.401 O CA
DANG_GLU 2.462 C N
DANG_GLU 2.455 CB N
DANG_GLU 2.504 C CB
DANG_GLU 2.559 CA CG
DANG_GLU 2.526 CB CD
DANG_GLU 2.379 CG OE1 CG OE2
DANG_GLU 2.194 OE1 OE2
 
CHIV_GLY C
DFIX_GLY 1.231 O C
DFIX_GLY 1.516 C CA
DFIX_GLY 1.451 CA N
DANG_GLY 2.467 C N
DANG_GLY 2.393 O CA
 
FLAT_HIS CB ND1 NE2 CD2 CE1 CG
CHIV_HIS C
CHIV_HIS 2.503 CA
DFIX_HIS 1.231 C O
DFIX_HIS 1.525 C CA
DFIX_HIS 1.458 CA N
DFIX_HIS 1.530 CA CB
DFIX_HIS 1.497 CB CG
DFIX_HIS 1.378 CG ND1
DFIX_HIS 1.321 ND1 CE1 CE1 NE2
DFIX_HIS 1.374 NE2 CD2
DFIX_HIS 1.354 CD2 CG
DANG_HIS 2.401 O CA
DANG_HIS 2.462 C N
DANG_HIS 2.504 C CB
DANG_HIS 2.455 N CB
DANG_HIS 2.536 CA CG
DANG_HIS 2.524 CB ND1
DANG_HIS 2.597 CB CD2
DANG_HIS 2.202 CG CE1
DANG_HIS 2.196 CG NE2
DANG_HIS 2.194 CE1 CD2
DANG_HIS 2.143 ND1 NE2
DANG_HIS 2.170 ND1 CD2
 
CHIV_ILE C
CHIV_ILE 2.516 CA
CHIV_ILE 2.495 CB
DFIX_ILE 1.231 C O
DFIX_ILE 1.525 C CA
DFIX_ILE 1.458 CA N
DFIX_ILE 1.540 CA CB
DFIX_ILE 1.530 CB CG1
DFIX_ILE 1.521 CB CG2
DFIX_ILE 1.513 CG1 CD1
DANG_ILE 2.401 O CA
DANG_ILE 2.462 C N
DANG_ILE 2.479 N CB
DANG_ILE 2.576 CA CG1
DANG_ILE 2.515 CA CG2
DANG_ILE 2.549 CB CD1
DANG_ILE 2.510 CG1 CG2
DANG_ILE 2.497 C CB
 
CHIV_LEU C
CHIV_LEU 2.503 CA
CHIV_LEU -2.589 CG
DFIX_LEU 1.231 C O
DFIX_LEU 1.525 C CA
DFIX_LEU 1.458 N CA
DFIX_LEU 1.530 CA CB CB CG
DFIX_LEU 1.521 CG CD1 CG CD2
DANG_LEU 2.401 O CA
DANG_LEU 2.462 C N
DANG_LEU 2.455 N CB
DANG_LEU 2.504 C CB
DANG_LEU 2.599 CA CG
DANG_LEU 2.510 CB CD1 CB CD2
DANG_LEU 2.504 CD1 CD2
 
CHIV_LYS C
CHIV_LYS 2.503 CA
DFIX_LYS 1.231 C O
DFIX_LYS 1.525 C CA
DFIX_LYS 1.458 CA N
DFIX_LYS 1.530 CA CB
DFIX_LYS 1.520 CB CG CG CD CD CE
DFIX_LYS 1.489 CE NZ
DANG_LYS 2.401 O CA
DANG_LYS 2.462 C N
DANG_LYS 2.455 N CB
DANG_LYS 2.504 C CB
DANG_LYS 2.559 CA CG
DANG_LYS 2.510 CB CD CG CE
DANG_LYS 2.493 CD NZ
 
FLAT_PHE CG CD1 CE2 CB CD2 CE1 CZ
CHIV_PHE C
CHIV_PHE 2.503 CA
DFIX_PHE 1.231 C O
DFIX_PHE 1.458 N CA
DFIX_PHE 1.525 C CA
DFIX_PHE 1.530 CA CB
DFIX_PHE 1.502 CB CG
DFIX_PHE 1.384 CG CD1 CG CD2
DFIX_PHE 1.382 CD1 CE1 CD2 CE2 CE1 CZ CE2 CZ
DANG_PHE 2.401 O CA
DANG_PHE 2.462 C N
DANG_PHE 2.504 C CB
DANG_PHE 2.455 N CB
DANG_PHE 2.555 CA CG
DANG_PHE 2.525 CB CD1 CB CD2
DANG_PHE 2.404 CG CE1 CG CE2
DANG_PHE 2.394 CD1 CZ CD2 CZ CE1 CE2
DANG_PHE 2.380 CD1 CD2
 
CHIV_PRO C N
CHIV_PRO 2.728 CA
DFIX_PRO 1.231 C O
DFIX_PRO 1.525 C CA
DFIX_PRO 1.466 CA N
DFIX_PRO 1.473 N CD
DFIX_PRO 1.503 CD CG
DFIX_PRO 1.492 CG CB
DFIX_PRO 1.530 CB CA
DANG_PRO 2.401 O CA
DANG_PRO 2.477 C N
DANG_PRO 2.504 C CB
DANG_PRO 2.437 CA CD
DANG_PRO 2.332 N CG
DANG_PRO 2.393 CD CB
DANG_PRO 2.390 CA CG
DANG_PRO 2.345 N CB
DANG_PRO 2.497 CD C_-
 
CHIV_SER C
CHIV_SER 2.503 CA
DFIX_SER 1.231 C O
DFIX_SER 1.525 C CA
DFIX_SER 1.458 N CA
DFIX_SER 1.530 CA CB
DFIX_SER 1.417 CB OG
DANG_SER 2.401 O CA
DANG_SER 2.462 C N
DANG_SER 2.504 C CB
DANG_SER 2.455 N CB
DANG_SER 2.431 CA OG
 
CHIV_THR C
CHIV_THR 2.516 CA
CHIV_THR -2.628 CB
DFIX_THR 1.231 C O
DFIX_THR 1.525 C CA
DFIX_THR 1.458 N CA
DFIX_THR 1.540 CA CB
DFIX_THR 1.433 CB OG1
DFIX_THR 1.521 CB CG2
DANG_THR 2.401 O CA
DANG_THR 2.462 C N
DANG_THR 2.497 C CB
DANG_THR 2.479 N CB
DANG_THR 2.430 CA OG1
DANG_THR 2.515 CA CG2
DANG_THR 2.373 OG1 CG2
 
FLAT_TYR CB CD1 CE2 CG CD2 CE1 CZ OH
CHIV_TYR C
CHIV_TYR 2.503 CA
DFIX_TYR 1.231 C O
DFIX_TYR 1.458 N CA
DFIX_TYR 1.525 C CA
DFIX_TYR 1.530 CA CB
DFIX_TYR 1.512 CB CG
DFIX_TYR 1.389 CG CD2 CG CD1
DFIX_TYR 1.382 CD2 CE2 CD1 CE1
DFIX_TYR 1.378 CE2 CZ CE1 CZ
DFIX_TYR 1.376 CZ OH
DANG_TYR 2.401 O CA
DANG_TYR 2.462 C N
DANG_TYR 2.455 N CB
DANG_TYR 2.504 C CB
DANG_TYR 2.550 CA CG
DANG_TYR 2.523 CB CD1 CB CD2
DANG_TYR 2.414 CG CE1 CG CE2
DANG_TYR 2.385 CZ CD1 CZ CD2
DANG_TYR 2.384 OH CE1 OH CE2
DANG_TYR 2.382 CD1 CD2
DANG_TYR 2.390 CE1 CE2
 
CHIV_VAL C
CHIV_VAL 2.516 CA
CHIV_VAL -2.622 CB
DFIX_VAL 1.231 C O
DFIX_VAL 1.458 N CA
DFIX_VAL 1.525 C CA
DFIX_VAL 1.540 CA CB
DFIX_VAL 1.521 CB CG2 CB CG1
DANG_VAL 2.401 O CA
DANG_VAL 2.462 C N
DANG_VAL 2.497 C CB
DANG_VAL 2.515 CA CG1 CA CG2
DANG_VAL 2.479 N CB
DANG_VAL 2.504 CG1 CG2
 
DFIX_GLC  1.404 O1   C1
DFIX_GLC  1.435 O2   C2
DFIX_GLC  1.441 O3   C3
DFIX_GLC  1.503 C1   C2
DFIX_GLC  1.553 C2   C3
 
DANG_GLC  2.357 O1   C2
DANG_GLC  2.370 O2   C1
DANG_GLC  2.462 O2   C3
DANG_GLC  2.567 C1   C3
DANG_GLC  2.517 O3   C2
 
DFIX 2.031 SG_1006 SG_1011 SG_1007 SG_2007 SG_1020 SG_2019
DANG 3.035 CB_1006 SG_1011 SG_1006 CB_1011 CB_1007 SG_2007 SG_1007 CB_2007
DANG 3.035 CB_1020 SG_2019 SG_1020 CB_2019
DFIX_1021 1.249 C OT1 C OT2
DANG_1021 2.379 CA OT1 CA OT2
DANG_1021 2.194 OT1 OT2
DFIX_2030 1.249 C OT1 C OT2
DANG_2030 2.379 CA OT1 CA OT2
DANG_2030 2.194 OT1 OT2
FREE O1_2501 O2_2501
 
DFIX_2007 1.417 CB OG
DANG_2007 2.431 CA OG
FREE OG_2007 SG_1007
 
WGHT    0.100000
SWAT    0.638734    1.8563
FVAR       0.03649   0.69272   0.63135   0.50354   0.42869   0.77165   0.51004
FVAR       0.52129   0.80351   0.50368   0.37957   0.34153
RESI 1001   GLY
N     3    0.100803    0.091505    0.827522    11.00000    0.51814    0.29611 =
         0.31800    0.06729   -0.19540   -0.00187
CA    1    0.087684    0.105071    0.825481    11.00000    0.44337    0.25343 =
         0.27079    0.04579   -0.16640   -0.05508
C     1    0.078993    0.102538    0.807985    11.00000    0.36621    0.23000 =
         0.20222    0.05438   -0.08221   -0.04308
O     4    0.080255    0.089082    0.799657    11.00000    0.31208    0.20889 =
         0.22189    0.06183   -0.06495   -0.06190
 
RESI 1002   ILE
N     3    0.069791    0.115879    0.802207    11.00000    0.31846    0.21291 =
         0.18295    0.06401   -0.04576   -0.06575
CA    1    0.059598    0.114058    0.786578    11.00000    0.27392    0.18607 =
         0.17422    0.04871   -0.01889   -0.03094
CB    1    0.048797    0.130263    0.783342    11.00000    0.25701    0.16697 =
         0.21552    0.02113   -0.00404   -0.03046
CG2   1    0.060004    0.145818    0.778787    11.00000    0.25705    0.17866 =
         0.25233    0.04890    0.01911   -0.02720
CG1   1    0.034807    0.127050    0.769751    11.00000    0.27327    0.16294 =
         0.21191    0.01692   -0.02329    0.00284
CD1   1    0.023324    0.142314    0.766331    11.00000    0.23190    0.18658 =
         0.25954   -0.01239    0.02283    0.02379
C     1    0.070655    0.110610    0.770849    11.00000    0.21308    0.16122 =
         0.18996    0.04568   -0.02894   -0.02910
O     4    0.065275    0.101398    0.759115    11.00000    0.21344    0.17319 =
         0.19826    0.02662   -0.03835   -0.01471
 
RESI 1003   VAL
N     3    0.086616    0.117335    0.770596    11.00000    0.23244    0.15099 =
         0.25607    0.05528   -0.02790   -0.04593
CA    1    0.097128    0.114340    0.755363    11.00000    0.20871    0.15962 =
         0.29079    0.06792   -0.00467   -0.03712
C     1    0.101609    0.095269    0.754724    11.00000    0.21993    0.16276 =
         0.26874    0.06471   -0.01335   -0.03580
O     4    0.101430    0.087212    0.740817    11.00000    0.16148    0.20413 =
         0.28655    0.03485   -0.03659   -0.00069
CB    1    0.112803    0.126079    0.756205    11.00000    0.24866    0.17733 =
         0.28678    0.01003    0.00161   -0.06100
CG1   1    0.125863    0.120878    0.742362    11.00000    0.19778    0.23613 =
         0.40506   -0.02033    0.03342   -0.05638
CG2   1    0.106496    0.144614    0.753661    11.00000    0.31497    0.15345 =
         0.39388   -0.01359    0.05726   -0.06646
 
RESI 1004   GLU
N     3    0.106150    0.087411    0.769304    11.00000    0.22514    0.19091 =
         0.27581    0.06923   -0.02220   -0.00647
CA    1    0.110543    0.069237    0.769709    11.00000    0.24364    0.19293 =
         0.29929    0.06189   -0.08717   -0.01084
C     1    0.095093    0.058397    0.764399    11.00000    0.22404    0.19581 =
         0.30904    0.02667   -0.09276    0.01548
O     4    0.096996    0.045632    0.755483    11.00000    0.21892    0.20943 =
         0.31885    0.02283   -0.03725    0.00000
CB    1    0.116435    0.064203    0.787746    11.00000    0.28990    0.26834 =
         0.34676    0.09747   -0.15511   -0.02714
CG    1    0.133511    0.072032    0.792619    11.00000    0.34277    0.37586 =
         0.39938    0.09695   -0.18098   -0.09906
CD    1    0.133722    0.091207    0.795781    11.00000    0.37261    0.40062 =
         0.59107   -0.00458   -0.07871   -0.13893
OE1   4    0.120975    0.099474    0.801214    11.00000    0.37021    0.40713 =
         0.31851    0.11109   -0.14619   -0.07633
OE2   4    0.148122    0.097849    0.792077    11.00000    0.43794    0.40025 =
         1.28152   -0.00650    0.11797   -0.14279
 
RESI 1005   GLN
N     3    0.079829    0.063400    0.769994    11.00000    0.24172    0.14322 =
         0.26682    0.06303   -0.04814    0.00212
CA    1    0.064899    0.052237    0.766468    11.00000    0.24999    0.16663 =
         0.22224    0.05819   -0.00668   -0.02205
C     1    0.056516    0.055208    0.748865    11.00000    0.22404    0.09167 =
         0.23020    0.04359   -0.00181   -0.00881
O     4    0.047865    0.043068    0.742988    11.00000    0.25890    0.09595 =
         0.24872    0.03688   -0.00311   -0.02492
CB    1    0.051896    0.055208    0.780374    11.00000    0.26630    0.20856 =
         0.21916    0.02609   -0.01273    0.00111
CG    1    0.058449    0.051350    0.798572    11.00000    0.31545    0.21351 =
         0.21851    0.03423   -0.02769   -0.03161
CD    1    0.068647    0.034778    0.799893    11.00000    0.37125    0.16305 =
         0.33752    0.08513   -0.10526   -0.06925
OE1   4    0.063605    0.021761    0.792245    11.00000    0.41249    0.16597 =
         0.28996    0.06847   -0.02933   -0.08119
NE2   3    0.083143    0.033691    0.809114    11.00000    0.42718    0.25087 =
         0.35411    0.13277   -0.14998   -0.03997
 
RESI 1006   CYS
N     3    0.058616    0.070667    0.741767    11.00000    0.18570    0.11663 =
         0.23315    0.05855   -0.01301   -0.01522
CA    1    0.048917    0.074746    0.726215    11.00000    0.15562    0.14285 =
         0.21536    0.04312   -0.00299    0.01520
C     1    0.060097    0.079242    0.710771    11.00000    0.15039    0.14331 =
         0.22370    0.04867   -0.00326    0.01478
O     4    0.053017    0.078027    0.696598    11.00000    0.18790    0.13521 =
         0.20881    0.04485    0.00225    0.00190
CB    1    0.037043    0.090448    0.729654    11.00000    0.16938    0.11481 =
         0.25359    0.03709    0.01671    0.00667
SG    5    0.018151    0.082984    0.741687    11.00000    0.19026    0.15778 =
         0.25965    0.01373    0.03611   -0.00766
 
RESI 1007   CYS
N     3    0.076352    0.084007    0.713718    11.00000    0.15149    0.14620 =
         0.24352    0.05849    0.00636    0.00316
CA    1    0.088004    0.087945    0.699209    11.00000    0.17243    0.15149 =
         0.24030    0.05831    0.00877   -0.00055
C     1    0.099855    0.072929    0.696531    11.00000    0.14703    0.17517 =
         0.23519    0.07464    0.01694   -0.00140
O     4    0.101107    0.065952    0.682588    11.00000    0.20048    0.21659 =
         0.25630    0.05309    0.03808    0.02944
CB    1    0.097005    0.104800    0.703440    11.00000    0.16252    0.16884 =
         0.31292    0.07342    0.00431   -0.02515
SG    5    0.114753    0.109366    0.688858    11.00000    0.17129    0.23904 =
         0.36531    0.12530    0.00323   -0.01193
 
RESI 1008   ALA
N     3    0.109008    0.068040    0.710395    11.00000    0.13210    0.19054 =
         0.27029    0.08998    0.00427   -0.00793
CA    1    0.121125    0.053751    0.709033    11.00000    0.12442    0.21068 =
         0.36115    0.08909   -0.03378   -0.00399
C     1    0.112084    0.036447    0.707360    11.00000    0.15459    0.19640 =
         0.33641    0.02949    0.05284    0.01168
O     4    0.119698    0.024027    0.701407    11.00000    0.21045    0.23555 =
         0.36730    0.01896    0.06935    0.05615
CB    1    0.132833    0.053687    0.724734    11.00000    0.15218    0.26921 =
         0.30659    0.05786   -0.01186    0.04118
 
RESI 1009   SER
N     3    0.096186    0.035545    0.712986    11.00000    0.13975    0.16580 =
         0.30470    0.04190    0.02596    0.00392
CA    1    0.085281    0.020723    0.711204    11.00000    0.14704    0.13807 =
         0.26261    0.02758    0.02141    0.02187
C     1    0.067815    0.026819    0.704368    11.00000    0.13811    0.14248 =
         0.25135    0.04225    0.02718    0.01438
O     4    0.064526    0.042025    0.703382    11.00000    0.17348    0.13859 =
         0.26394    0.05571    0.03120    0.02584
PART    1
CB    1    0.083415    0.010351    0.727798    71.00000    0.20607    0.16866 =
         0.30636    0.08178    0.02275    0.05099
OG    4    0.074274    0.018974    0.740816    71.00000    0.21466    0.14822 =
         0.24752    0.06665   -0.00377    0.00977
PART    2
CB    1    0.083269    0.011760    0.728634   -71.00000    0.22389    0.20943 =
         0.30673    0.09774   -0.03564   -0.01910
OG    4    0.098064    0.011926    0.739303   -71.00000    0.24018    0.28350 =
         0.40264    0.17158   -0.08490   -0.03779
 
RESI 1010   VAL
PART    0
N     3    0.056860    0.014140    0.700078    11.00000    0.15293    0.16477 =
         0.20979    0.03184    0.02881    0.00448
CA    1    0.040005    0.018494    0.692365    11.00000    0.15319    0.13884 =
         0.23393   -0.02412    0.01490    0.02716
C     1    0.028369    0.025943    0.706094    11.00000    0.17886    0.11094 =
         0.22620   -0.01136    0.02800    0.01560
O     4    0.026312    0.018427    0.720104    11.00000    0.15582    0.15291 =
         0.24018    0.01619    0.01975   -0.00388
CB    1    0.032148    0.002423    0.684284    11.00000    0.17748    0.15073 =
         0.25814   -0.04942    0.02597    0.01827
CG1   1    0.014704    0.007260    0.676757    11.00000    0.19059    0.21916 =
         0.30623   -0.03977   -0.02099   -0.01563
CG2   1    0.043149   -0.004700    0.669662    11.00000    0.26313    0.18356 =
         0.22335   -0.03246    0.05582    0.00808
 
RESI 1011   CYS
N     3    0.020916    0.040824    0.701869    11.00000    0.12995    0.12150 =
         0.26230    0.00182    0.04409    0.01842
CA    1    0.009377    0.049187    0.713908    11.00000    0.12621    0.12183 =
         0.24650   -0.00507    0.04159    0.00215
C     1   -0.007709    0.039780    0.715036    11.00000    0.12076    0.15464 =
         0.25689   -0.01078    0.02952   -0.00977
O     4   -0.011157    0.027549    0.705535    11.00000    0.15548    0.15077 =
         0.32829   -0.03876    0.02343   -0.00568
CB    1    0.006727    0.067725    0.706868    11.00000    0.17691    0.09726 =
         0.31984   -0.02002    0.00120    0.00748
SG    5   -0.000648    0.082968    0.722360    11.00000    0.16869    0.13690 =
         0.31716   -0.02359    0.02378    0.00633
 
RESI 1012   SER
N     3   -0.019075    0.045800    0.726323    11.00000    0.11693    0.19548 =
         0.30907   -0.02523    0.04031   -0.00049
CA    1   -0.036376    0.038624    0.727726    11.00000    0.12036    0.14496 =
         0.41069   -0.04178    0.06982   -0.00750
C     1   -0.047690    0.052873    0.735021    11.00000    0.11031    0.14780 =
         0.35867   -0.05253    0.04147   -0.02151
O     4   -0.041874    0.065315    0.743000    11.00000    0.13447    0.15035 =
         0.32951   -0.04147    0.02184   -0.02202
CB    1   -0.037422    0.023406    0.740171    11.00000    0.21288    0.15236 =
         0.48659    0.00010    0.01869   -0.03635
OG    4   -0.033043    0.028567    0.757168    11.00000    0.18799    0.16966 =
         0.46797    0.02494    0.02191   -0.01454
 
RESI 1013   LEU
N     3   -0.064332    0.051035    0.732149    11.00000    0.10181    0.15045 =
         0.38077   -0.04894    0.05357   -0.01874
CA    1   -0.076524    0.063587    0.738749    11.00000    0.11701    0.14769 =
         0.30344   -0.01151    0.04800   -0.00903
C     1   -0.076405    0.063688    0.758010    11.00000    0.14159    0.11567 =
         0.30381    0.00883    0.03169   -0.01071
O     4   -0.076995    0.077064    0.766178    11.00000    0.14165    0.13612 =
         0.31802   -0.02068    0.02303   -0.01818
CB    1   -0.094315    0.059659    0.731746    11.00000    0.11725    0.13097 =
         0.30102   -0.01254    0.03930   -0.00524
CG    1   -0.108263    0.072040    0.737992    11.00000    0.12384    0.11188 =
         0.21758    0.00101    0.03029   -0.00934
CD1   1   -0.104026    0.090786    0.733320    11.00000    0.19304    0.11045 =
         0.18812    0.01246    0.01818   -0.02279
CD2   1   -0.125354    0.066487    0.730629    11.00000    0.12644    0.14833 =
         0.19207    0.01314    0.01693   -0.00991
 
RESI 1014   TYR
N     3   -0.075095    0.048490    0.765532    11.00000    0.12450    0.13890 =
         0.37629    0.05074    0.04209   -0.00893
CA    1   -0.075244    0.046364    0.783800    11.00000    0.16503    0.12328 =
         0.38169    0.06455    0.02254    0.00592
C     1   -0.060831    0.057749    0.790818    11.00000    0.15617    0.12646 =
         0.38548    0.02556    0.03060    0.02676
O     4   -0.063658    0.066518    0.803761    11.00000    0.20672    0.16921 =
         0.33146    0.04406    0.00968    0.05370
CB    1   -0.072513    0.026864    0.787377    11.00000    0.19492    0.12710 =
         0.44504    0.07665    0.01851    0.00722
CG    1   -0.072906    0.023782    0.806478    11.00000    0.29521    0.14517 =
         0.44156    0.09421    0.02589    0.11206
CD1   1   -0.058930    0.027295    0.817611    11.00000    0.29532    0.19308 =
         0.40807    0.06314    0.04325    0.10998
CD2   1   -0.088385    0.016276    0.812447    11.00000    0.30528    0.20839 =
         0.34372    0.05226    0.04324    0.10059
CE1   1   -0.058266    0.024864    0.834764    11.00000    0.35990    0.23664 =
         0.41864    0.10761    0.03292    0.11239
CE2   1   -0.088539    0.013757    0.830316    11.00000    0.36691    0.17630 =
         0.33301    0.02954    0.01705    0.13328
CZ    1   -0.074232    0.017914    0.840035    11.00000    0.35505    0.21759 =
         0.34874    0.03722    0.03124    0.09884
OH    4   -0.074156    0.015109    0.857247    11.00000    0.36914    0.25464 =
         0.33678    0.00640    0.01573    0.05834
 
RESI 1015   GLN
N     3   -0.045428    0.055953    0.783094    11.00000    0.14598    0.15641 =
         0.35412    0.06058    0.02325    0.01691
CA    1   -0.030984    0.066106    0.790312    11.00000    0.16132    0.18283 =
         0.38505    0.05918    0.00663    0.00778
C     1   -0.032431    0.085087    0.786523    11.00000    0.18497    0.17655 =
         0.26066    0.04410    0.02203   -0.02374
O     4   -0.029221    0.095847    0.797757    11.00000    0.21385    0.19949 =
         0.26567    0.04827   -0.03405   -0.01760
PART    1
CB    1   -0.013826    0.058868    0.784048    21.00000    0.14937    0.23951 =
         0.40920    0.04499   -0.00781    0.01450
CG    1   -0.009685    0.042303    0.793809    21.00000    0.18260    0.25650 =
         0.45043    0.04817   -0.04288    0.05140
CD    1    0.007971    0.035141    0.790134    21.00000    0.20344    0.22289 =
         0.33936   -0.02906   -0.02520    0.04180
OE1   4    0.010260    0.026031    0.777649    21.00000    0.44094    0.24648 =
         0.34563   -0.04759    0.03456    0.00065
NE2   3    0.020695    0.039023    0.800697    21.00000    0.20782    0.21741 =
         0.40192    0.01047   -0.08041    0.07290
PART    2
CB    1   -0.014384    0.058623    0.782784   -21.00000    0.14514    0.25701 =
         0.43950    0.00660   -0.01823    0.02202
CG    1   -0.011347    0.040238    0.789329   -21.00000    0.18926    0.22079 =
         0.42657   -0.06481   -0.05863    0.04150
CD    1   -0.005705    0.041265    0.808108   -21.00000    0.17101    0.25903 =
         0.45942   -0.02981   -0.11662    0.03336
OE1   4   -0.009206    0.029720    0.818483   -21.00000    0.34506    0.13561 =
         0.47189   -0.05773   -0.25485   -0.00622
NE2   3    0.003117    0.055628    0.811666   -21.00000    0.18359    0.34165 =
         0.41839    0.12173   -0.22134   -0.07152
 
RESI 1016   LEU
PART    0
N     3   -0.037648    0.089860    0.770961    11.00000    0.16367    0.18160 =
         0.24378    0.02140    0.03947   -0.02281
CA    1   -0.039550    0.108219    0.767453    11.00000    0.14324    0.18280 =
         0.20845    0.02974   -0.00199   -0.03984
C     1   -0.052203    0.116905    0.779884    11.00000    0.15229    0.15023 =
         0.20168    0.02928   -0.00870   -0.03776
O     4   -0.048788    0.131151    0.785388    11.00000    0.18885    0.14727 =
         0.17209    0.04443   -0.01564   -0.04995
CB    1   -0.046251    0.111459    0.749386    11.00000    0.13607    0.29032 =
         0.20026    0.01296   -0.02358   -0.02436
CG    1   -0.033946    0.108814    0.735053    11.00000    0.14881    0.25424 =
         0.22680    0.03928    0.00864   -0.05262
CD1   1   -0.042371    0.108823    0.717590    11.00000    0.20713    0.33407 =
         0.21140    0.03052    0.01645   -0.00135
CD2   1   -0.019830    0.122896    0.735936    11.00000    0.24422    0.14090 =
         0.32322    0.00626    0.06169   -0.05718
 
RESI 1017   GLU
N     3   -0.066663    0.107953    0.783972    11.00000    0.15234    0.15507 =
         0.17639    0.05450   -0.00488   -0.03229
CA    1   -0.079226    0.116602    0.795214    11.00000    0.15651    0.16007 =
         0.19335    0.02412   -0.00407   -0.04264
C     1   -0.071946    0.119559    0.813001    11.00000    0.18935    0.17020 =
         0.20180    0.01263   -0.00855   -0.06470
O     4   -0.078800    0.131180    0.821858    11.00000    0.23389    0.22343 =
         0.20725   -0.00508    0.02475   -0.05508
CB    1   -0.096215    0.106565    0.796279    11.00000    0.15724    0.12260 =
         0.19794    0.02588   -0.01004   -0.03227
CG    1   -0.106265    0.109534    0.779804    11.00000    0.16854    0.18919 =
         0.18113    0.04376   -0.00731   -0.05112
CD    1   -0.124810    0.104917    0.781761    11.00000    0.16916    0.15987 =
         0.17026    0.03109   -0.01354   -0.03625
OE1   4   -0.129315    0.093177    0.791554    11.00000    0.16064    0.16032 =
         0.24137    0.04969    0.03215   -0.02201
OE2   4   -0.135469    0.112359    0.772644    11.00000    0.18155    0.24974 =
         0.20576    0.06479   -0.01074   -0.01011
 
RESI 1018   ASN
N     3   -0.058616    0.110283    0.818068    11.00000    0.22283    0.18518 =
         0.17466    0.06786   -0.02285   -0.06582
CA    1   -0.050812    0.114227    0.834892    11.00000    0.27172    0.23305 =
         0.17846    0.07684   -0.03035   -0.10811
C     1   -0.042278    0.131555    0.835274    11.00000    0.29938    0.19793 =
         0.16720    0.06355   -0.03184   -0.08916
O     4   -0.038315    0.137726    0.849392    11.00000    0.38406    0.29809 =
         0.17235    0.05178   -0.02720   -0.16523
CB    1   -0.037504    0.100374    0.839147    11.00000    0.35886    0.19953 =
         0.24842    0.10458   -0.12588   -0.11082
CG    1   -0.047074    0.085008    0.846187    11.00000    0.46836    0.21797 =
         0.24718    0.07776   -0.12563   -0.17251
OD1   4   -0.061689    0.085523    0.852315    11.00000    0.40169    0.36441 =
         0.51537    0.28294   -0.15229   -0.18838
ND2   3   -0.038239    0.070583    0.844566    11.00000    0.54188    0.19874 =
         0.46906    0.10488   -0.26703   -0.13707
 
RESI 1019   TYR
N     3   -0.039619    0.139622    0.820503    11.00000    0.21287    0.17455 =
         0.17466    0.05899   -0.01860   -0.05796
CA    1   -0.031624    0.156853    0.820215    11.00000    0.22959    0.16902 =
         0.17648    0.03862   -0.00347   -0.05976
C     1   -0.044892    0.170545    0.816862    11.00000    0.23493    0.16554 =
         0.18581    0.03104   -0.01932   -0.05577
O     4   -0.040337    0.185746    0.816280    11.00000    0.26136    0.16763 =
         0.23653    0.02961   -0.01552   -0.06001
CB    1   -0.017285    0.157345    0.806550    11.00000    0.22668    0.18511 =
         0.15994    0.04673   -0.01234   -0.05898
CG    1   -0.003525    0.144551    0.811870    11.00000    0.21237    0.21032 =
         0.21205    0.05081   -0.01150   -0.06014
CD1   1    0.008384    0.149984    0.824490    11.00000    0.19981    0.31379 =
         0.20029    0.05173   -0.01803   -0.04280
CD2   1   -0.003076    0.128131    0.804903    11.00000    0.19664    0.21438 =
         0.30069    0.03327    0.02698   -0.03449
CE1   1    0.020756    0.138424    0.829320    11.00000    0.23437    0.40337 =
         0.28423    0.13325   -0.02306   -0.01215
CE2   1    0.009485    0.116570    0.810044    11.00000    0.22859    0.26989 =
         0.39776    0.09937    0.06769    0.01094
CZ    1    0.021196    0.122265    0.822245    11.00000    0.20199    0.36036 =
         0.35279    0.16855    0.04999    0.02501
OH    4    0.033894    0.111659    0.828175    11.00000    0.27102    0.52604 =
         0.49117    0.22259    0.05699    0.12791
 
RESI 1020   CYS
N     3   -0.061321    0.166529    0.815294    11.00000    0.23412    0.18798 =
         0.16544    0.01218   -0.02153   -0.04856
CA    1   -0.074328    0.180126    0.814206    11.00000    0.23371    0.20303 =
         0.18844    0.00616    0.03798   -0.02777
CB    1   -0.091758    0.173425    0.808363    11.00000    0.21657    0.23009 =
         0.19626    0.01428    0.04464   -0.02068
SG    5   -0.091573    0.162681    0.787822    11.00000    0.20746    0.16816 =
         0.21799    0.02441    0.02719   -0.02582
C     1   -0.076521    0.187589    0.832179    11.00000    0.30814    0.19891 =
         0.17563    0.02541    0.04530   -0.04649
O     4   -0.074256    0.178927    0.845076    11.00000    0.39688    0.26259 =
         0.18933    0.05012    0.04986   -0.02144
 
RESI 1021   ASN
N     3   -0.081260    0.204019    0.832637    11.00000    0.33642    0.20481 =
         0.20476   -0.00404    0.06011   -0.03718
CA    1   -0.084893    0.211848    0.849302    11.00000    0.44056    0.30049 =
         0.23777   -0.04280    0.11082   -0.01607
CB    1   -0.085520    0.231288    0.847553    11.00000    0.42627    0.29932 =
         0.24423   -0.06582    0.14779    0.02109
CG    1   -0.068554    0.239376    0.842444    11.00000    0.39357    0.27354 =
         0.23285   -0.01918    0.05030    0.01576
OD1   4   -0.055021    0.234771    0.849256    11.00000    0.46402    0.33198 =
         0.33360   -0.00035   -0.08364   -0.03402
ND2   3   -0.069680    0.251317    0.830236    11.00000    0.45553    0.27613 =
         0.26236    0.00146   -0.00800   -0.04261
C     1   -0.102109    0.205918    0.856514    11.00000    0.51666    0.41947 =
         0.25654   -0.07775    0.16341   -0.10151
OT1   4   -0.113454    0.199785    0.846677    11.00000    0.42008    0.44601 =
         0.30471   -0.03803    0.12277   -0.01998
OT2   4   -0.103948    0.207577    0.872349    11.00000    0.64973    0.80140 =
         0.29192   -0.19050    0.23673   -0.20118
 
RESI 2001   PHE
N     3   -0.074795    0.080042    0.621691    11.00000    0.32834    0.32427 =
         0.26779   -0.03660   -0.09634   -0.07635
CA    1   -0.059785    0.091143    0.622648    11.00000    0.29416    0.23347 =
         0.19310   -0.02019   -0.02330   -0.02111
CB    1   -0.065140    0.109927    0.620571    11.00000    0.43455    0.25390 =
         0.22820    0.02223    0.03679    0.03263
CG    1   -0.077761    0.115779    0.633991    11.00000    0.41395    0.22315 =
         0.28435   -0.00641    0.05388    0.00414
CD1   1   -0.072061    0.125250    0.647846    11.00000    0.46388    0.24910 =
         0.27381   -0.01048    0.07764   -0.02186
CD2   1   -0.095065    0.111999    0.632583    11.00000    0.41467    0.39528 =
         0.42882   -0.07665    0.05141   -0.00472
CE1   1   -0.083589    0.131359    0.660065    11.00000    0.51308    0.16078 =
         0.30218    0.01858    0.13427   -0.04932
CE2   1   -0.106616    0.117842    0.644909    11.00000    0.37061    0.44671 =
         0.44680   -0.03953    0.00723    0.11262
CZ    1   -0.101237    0.127501    0.658901    11.00000    0.43742    0.28335 =
         0.29293    0.09776    0.02718    0.13920
C     1   -0.049827    0.087961    0.639238    11.00000    0.21982    0.24512 =
         0.17929   -0.06417   -0.00273    0.00279
O     4   -0.035043    0.093725    0.640077    11.00000    0.24132    0.33416 =
         0.27970   -0.00084   -0.01313   -0.05422
 
RESI 2002   VAL
N     3   -0.057382    0.079473    0.652570    11.00000    0.21640    0.18257 =
         0.20705   -0.02794   -0.01601    0.02436
CA    1   -0.047939    0.078220    0.668700    11.00000    0.20502    0.15239 =
         0.21424   -0.02354   -0.03000    0.00934
C     1   -0.036956    0.062137    0.670439    11.00000    0.16865    0.15612 =
         0.24355   -0.04114   -0.02632   -0.00143
O     4   -0.025019    0.062554    0.680724    11.00000    0.17809    0.17060 =
         0.26312   -0.02335   -0.03863   -0.00743
CB    1   -0.060296    0.078922    0.684407    11.00000    0.25571    0.18962 =
         0.21467   -0.02594   -0.00935    0.05829
CG1   1   -0.070644    0.095476    0.684941    11.00000    0.26778    0.23374 =
         0.28877   -0.05024   -0.06725    0.10427
CG2   1   -0.072130    0.063218    0.684825    11.00000    0.29853    0.24287 =
         0.38587    0.09081    0.05063    0.01493
 
RESI 2003   ASN
N     3   -0.040714    0.048792    0.660766    11.00000    0.13799    0.18170 =
         0.35416   -0.10460   -0.02327    0.00509
CA    1   -0.032303    0.032287    0.663899    11.00000    0.10925    0.16874 =
         0.47490   -0.08039    0.02947   -0.01285
C     1   -0.016993    0.030003    0.651964    11.00000    0.15980    0.15359 =
         0.40100   -0.04442    0.04554   -0.00608
O     4   -0.016423    0.018691    0.641100    11.00000    0.19749    0.20492 =
         0.44535   -0.09120    0.03412   -0.00042
CB    1   -0.045256    0.017593    0.660889    11.00000    0.12437    0.19125 =
         0.53731   -0.12276    0.02971   -0.02701
CG    1   -0.059413    0.019046    0.674400    11.00000    0.13293    0.12535 =
         0.54204   -0.07070    0.03819   -0.02926
OD1   4   -0.056284    0.015880    0.689283    11.00000    0.16434    0.21687 =
         0.53972   -0.07843    0.03612    0.00594
ND2   3   -0.074841    0.023935    0.668743    11.00000    0.13616    0.17961 =
         0.56773   -0.08121    0.03968    0.00766
 
RESI 2004   GLN
N     3   -0.004597    0.041619    0.654409    11.00000    0.15575    0.16938 =
         0.32028    0.00028    0.03872   -0.01402
CA    1    0.010654    0.041848    0.643680    11.00000    0.14766    0.24414 =
         0.25469   -0.00842    0.00920   -0.01855
C     1    0.024802    0.051023    0.653996    11.00000    0.15130    0.16111 =
         0.21965   -0.00407    0.02596   -0.00634
O     4    0.021025    0.057738    0.667813    11.00000    0.15688    0.15971 =
         0.21603    0.00881    0.03256    0.00430
PART    1
CB    1    0.007471    0.050950    0.626553    31.00000    0.23275    0.25286 =
         0.23469   -0.02928   -0.01062   -0.00162
CG    1    0.002645    0.069900    0.628905    31.00000    0.27568    0.25304 =
         0.18283   -0.01929    0.04993    0.00791
CD    1   -0.002619    0.078387    0.611915    31.00000    0.30459    0.29032 =
         0.22756    0.03560    0.03973   -0.00548
OE1   4   -0.014809    0.088389    0.610867    31.00000    0.25698    0.41250 =
         0.36577    0.07510   -0.02016    0.00433
NE2   3    0.006932    0.074358    0.598182    31.00000    0.42083    0.36626 =
         0.19635    0.02948    0.06779   -0.02831
PART    2
CB    1    0.007802    0.050359    0.626298   -31.00000    0.23568    0.26559 =
         0.23454   -0.02749   -0.01072   -0.00486
CG    1    0.004494    0.069689    0.626865   -31.00000    0.26706    0.27186 =
         0.22016   -0.00989   -0.00650    0.02060
CD    1   -0.003482    0.075834    0.609935   -31.00000    0.30630    0.33296 =
         0.22948    0.01860   -0.01217    0.01982
OE1   4    0.004046    0.086236    0.600604   -31.00000    0.33819    0.46493 =
         0.27692    0.09752   -0.01638   -0.01370
NE2   3   -0.018655    0.068945    0.606163   -31.00000    0.39587    0.20373 =
         0.22349   -0.01961   -0.07966   -0.00239
 
RESI 2005   HIS
PART    0
N     3    0.040168    0.051214    0.646976    11.00000    0.14859    0.16317 =
         0.25923   -0.01817    0.04199   -0.00508
CA    1    0.053372    0.061940    0.655047    11.00000    0.13700    0.13742 =
         0.24050    0.00780    0.03464    0.00683
C     1    0.049341    0.080825    0.650884    11.00000    0.17136    0.14840 =
         0.19569    0.00689    0.01719    0.01165
O     4    0.046061    0.085539    0.635962    11.00000    0.22459    0.18790 =
         0.20022    0.01444    0.00030    0.01649
CB    1    0.070890    0.058058    0.647169    11.00000    0.14722    0.18604 =
         0.22168    0.00335    0.03057    0.01938
CG    1    0.077193    0.040145    0.651372    11.00000    0.16328    0.17905 =
         0.28488   -0.01477    0.04142    0.03762
ND1   3    0.073566    0.026432    0.640880    11.00000    0.31732    0.20728 =
         0.37376   -0.05906    0.00358    0.04503
CE1   1    0.080824    0.012317    0.647478    11.00000    0.29436    0.19198 =
         0.38283   -0.03511    0.12460    0.06368
NE2   3    0.088994    0.016435    0.661872    11.00000    0.28822    0.18964 =
         0.35776    0.04716    0.10360    0.06110
CD2   1    0.086745    0.034120    0.664453    11.00000    0.21152    0.18847 =
         0.25906    0.03995    0.07962    0.04894
 
RESI 2006   LEU
N     3    0.049777    0.091250    0.663994    11.00000    0.16748    0.13083 =
         0.19512    0.00811    0.01985   -0.01453
CA    1    0.045540    0.109539    0.663035    11.00000    0.15218    0.12447 =
         0.22050    0.02501    0.00981   -0.02387
C     1    0.059376    0.119848    0.672313    11.00000    0.14158    0.12134 =
         0.20395    0.02508    0.01699   -0.01163
O     4    0.061486    0.117927    0.688029    11.00000    0.16256    0.15850 =
         0.20717    0.03917   -0.00320   -0.00870
CB    1    0.028244    0.112837    0.671721    11.00000    0.13415    0.14157 =
         0.27055    0.03222   -0.00099   -0.00780
CG    1    0.012551    0.104308    0.663550    11.00000    0.14380    0.14343 =
         0.26631    0.02700   -0.02121    0.00865
CD1   1   -0.002804    0.105959    0.675526    11.00000    0.13993    0.14193 =
         0.37394    0.02133    0.02279    0.00631
CD2   1    0.009110    0.112124    0.645930    11.00000    0.23680    0.19763 =
         0.30100    0.06555   -0.06527    0.01279
 
RESI 2007   CYS
N     3    0.068568    0.130303    0.662481    11.00000    0.13629    0.12149 =
         0.21538    0.02500    0.01977   -0.01382
CA    1    0.083034    0.139714    0.669845    11.00000    0.13346    0.13016 =
         0.23506    0.04162    0.01461   -0.01706
C     1    0.081292    0.158777    0.665909    11.00000    0.11517    0.12790 =
         0.21475    0.04881   -0.00531   -0.01777
O     4    0.074224    0.163775    0.652272    11.00000    0.14548    0.17032 =
         0.19173    0.04477    0.00761   -0.00009
CB    1    0.100057    0.133951    0.662114    11.00000    0.14198    0.17272 =
         0.31500    0.05187    0.03075    0.02507
PART 1
SG    5    0.103545    0.110601    0.665168    91.00000    0.16048    0.17542 =
         0.31956    0.06280    0.04957    0.02459
PART 2
OG    4    0.103099    0.116252    0.665265   -91.00000    0.17245    0.26278 =
         0.26526    0.20641   -0.01283    0.12160
 
RESI 2008   GLY
PART 0
N     3    0.087376    0.169312    0.677595    11.00000    0.12488    0.14070 =
         0.26061    0.03389   -0.02827   -0.03845
CA    1    0.088134    0.187856    0.674211    11.00000    0.12444    0.13896 =
         0.22479    0.05420   -0.03361   -0.02588
C     1    0.070830    0.195206    0.670457    11.00000    0.11567    0.14924 =
         0.14388    0.03956   -0.00706   -0.03405
O     4    0.058089    0.192446    0.679383    11.00000    0.13672    0.16732 =
         0.15023    0.02998    0.01190   -0.03513
 
RESI 2009   SER
N     3    0.069790    0.205327    0.656401    11.00000    0.13448    0.15242 =
         0.13149    0.03498   -0.00345   -0.00531
CA    1    0.053417    0.213967    0.652344    11.00000    0.11484    0.14705 =
         0.15325    0.03027   -0.00616   -0.01888
C     1    0.039386    0.200974    0.649109    11.00000    0.12228    0.14684 =
         0.14768    0.01440    0.00947   -0.01190
O     4    0.024279    0.205032    0.651466    11.00000    0.11629    0.14518 =
         0.15904    0.03103    0.01916   -0.01631
CB    1    0.055751    0.225757    0.636649    11.00000    0.15896    0.14641 =
         0.17086    0.04961    0.01279    0.00765
OG    4    0.058834    0.215687    0.621444    11.00000    0.22419    0.19287 =
         0.15017    0.03682    0.01133   -0.06158
 
RESI 2010   HIS
N     3    0.043831    0.185379    0.643548    11.00000    0.14191    0.13075 =
         0.13907    0.02858    0.00590   -0.01620
CA    1    0.030855    0.172417    0.640129    11.00000    0.14306    0.14292 =
         0.14031    0.01298    0.01201   -0.02057
C     1    0.022533    0.166654    0.656793    11.00000    0.13589    0.12675 =
         0.14495    0.02466   -0.00048   -0.02458
O     4    0.007145    0.162247    0.657312    11.00000    0.13754    0.14133 =
         0.19087    0.04472    0.01135   -0.02584
CB    1    0.038982    0.156807    0.631676    11.00000    0.14535    0.15611 =
         0.17949   -0.00833    0.00565   -0.00489
CG    1    0.047279    0.160884    0.614854    11.00000    0.13511    0.20879 =
         0.18007   -0.02095    0.01029    0.01017
ND1   3    0.051803    0.147567    0.603867    11.00000    0.21542    0.25808 =
         0.22136   -0.04690    0.02400    0.05159
CE1   1    0.058864    0.154376    0.589754    11.00000    0.21782    0.32708 =
         0.20122   -0.08910    0.02977   -0.03472
NE2   3    0.058867    0.171465    0.591222    11.00000    0.12689    0.31963 =
         0.16252   -0.03426    0.00689   -0.00365
CD2   1    0.051786    0.175820    0.607031    11.00000    0.12772    0.24834 =
         0.14747   -0.01015    0.01408   -0.02363
 
RESI 2011   LEU
N     3    0.032237    0.165872    0.670609    11.00000    0.15399    0.14449 =
         0.13465    0.02549    0.00410   -0.00410
CA    1    0.025918    0.160361    0.687544    11.00000    0.14386    0.13046 =
         0.13870    0.02907    0.01112    0.01128
C     1    0.015179    0.174690    0.695423    11.00000    0.13329    0.11184 =
         0.14907    0.02208    0.00627   -0.01381
O     4    0.001263    0.171828    0.702129    11.00000    0.12466    0.12963 =
         0.15092    0.02592    0.00353    0.00027
CB    1    0.041567    0.155786    0.698749    11.00000    0.14264    0.15370 =
         0.15201    0.04719    0.00558    0.00138
CG    1    0.037175    0.150114    0.717327    11.00000    0.13397    0.14737 =
         0.15188    0.04477    0.00497   -0.00260
CD1   1    0.023498    0.136395    0.717808    11.00000    0.18545    0.13407 =
         0.20092    0.06071    0.01867   -0.01704
CD2   1    0.054029    0.143384    0.725396    11.00000    0.18585    0.18308 =
         0.19452    0.05723   -0.02771    0.03241
 
RESI 2012   VAL
N     3    0.021236    0.190678    0.694162    11.00000    0.15074    0.11151 =
         0.12785    0.02328   -0.01770   -0.00877
CA    1    0.010952    0.204939    0.700864    11.00000    0.14520    0.11637 =
         0.18419   -0.00557   -0.05106   -0.01872
C     1   -0.005748    0.206295    0.690925    11.00000    0.13007    0.12582 =
         0.13105    0.02160   -0.00881   -0.01366
O     4   -0.019511    0.210009    0.698403    11.00000    0.13900    0.13069 =
         0.14641    0.01094    0.01002   -0.02184
PART    1
CB    1    0.023359    0.220201    0.697696    61.00000    0.24005    0.11903 =
         0.35001    0.03369   -0.15148   -0.06861
CG1   1    0.015755    0.236506    0.696459    61.00000    0.39795    0.13380 =
         0.25770    0.06299   -0.14586   -0.03328
CG2   1    0.036200    0.220441    0.712981    61.00000    0.14378    0.15302 =
         0.34316   -0.06169   -0.11138   -0.00450
PART    2
CB    1    0.021528    0.221612    0.701316   -61.00000    0.07375    0.08772 =
         0.34719    0.00899   -0.02779    0.03722
CG1   1    0.024686    0.229839    0.684297   -61.00000    0.12299    0.00001 =
         0.31372   -0.08999    0.06924    0.01925
CG2   1    0.010907    0.231988    0.713421   -61.00000    0.20587    0.14087 =
         0.33200   -0.06544    0.12029   -0.13538
 
RESI 2013   GLU
PART    0
N     3   -0.005632    0.203080    0.674199    11.00000    0.13754    0.11370 =
         0.12708    0.02319   -0.01321   -0.01780
CA    1   -0.021739    0.203571    0.664311    11.00000    0.12969    0.12834 =
         0.12602    0.02725   -0.00298   -0.02721
C     1   -0.034140    0.189839    0.670426    11.00000    0.13210    0.10469 =
         0.13439    0.01319    0.01633   -0.01209
O     4   -0.049744    0.193075    0.671971    11.00000    0.11862    0.12485 =
         0.16266    0.00553    0.01205   -0.01317
CB    1   -0.017386    0.200912    0.645238    11.00000    0.13276    0.19473 =
         0.12230    0.02678    0.00340   -0.02202
CG    1   -0.033500    0.197558    0.634446    11.00000    0.15615    0.28295 =
         0.13479   -0.01636   -0.01252   -0.00291
CD    1   -0.028001    0.197287    0.615592    11.00000    0.21023    0.34063 =
         0.14225   -0.05000   -0.00563   -0.05603
OE1   4   -0.021908    0.211090    0.610566    11.00000    0.21734    0.34316 =
         0.14813    0.02631   -0.00915   -0.00760
OE2   4   -0.030029    0.184156    0.607563    11.00000    0.45113    0.47978 =
         0.19442   -0.15208    0.06618   -0.23727
 
RESI 2014   ALA
N     3   -0.027572    0.174521    0.674237    11.00000    0.13585    0.10149 =
         0.14792    0.01949    0.01820   -0.01394
CA    1   -0.039224    0.160471    0.680478    11.00000    0.15633    0.09855 =
         0.14153    0.01461    0.02081   -0.01868
C     1   -0.046396    0.165399    0.697704    11.00000    0.14135    0.11612 =
         0.14811    0.00597    0.02189   -0.03258
O     4   -0.061938    0.162734    0.700993    11.00000    0.14120    0.12386 =
         0.17759    0.01399    0.02156   -0.02637
CB    1   -0.028995    0.143937    0.681504    11.00000    0.16829    0.09591 =
         0.17190    0.01395    0.00310   -0.00798
 
RESI 2015   LEU
N     3   -0.035848    0.172269    0.709264    11.00000    0.16956    0.10817 =
         0.13593    0.01273    0.00431   -0.02697
CA    1   -0.042631    0.178068    0.726085    11.00000    0.15397    0.14198 =
         0.13138    0.01757    0.00433   -0.01631
C     1   -0.056447    0.191399    0.723611    11.00000    0.14430    0.12728 =
         0.15346    0.02526    0.02400   -0.02838
O     4   -0.069835    0.191006    0.731903    11.00000    0.15324    0.14373 =
         0.16156    0.00498    0.04215   -0.02621
CB    1   -0.028350    0.185990    0.736746    11.00000    0.17857    0.14709 =
         0.13224    0.02008   -0.02291   -0.02246
CG    1   -0.016029    0.172669    0.744544    11.00000    0.18492    0.12903 =
         0.14665    0.03547   -0.01476   -0.03163
CD1   1    0.000433    0.181356    0.750383    11.00000    0.18954    0.15118 =
         0.19703    0.02615   -0.05902   -0.01808
CD2   1   -0.024137    0.163338    0.759920    11.00000    0.28613    0.17288 =
         0.14982    0.05066    0.03554   -0.02341
 
RESI 2016   TYR
N     3   -0.053315    0.203640    0.712110    11.00000    0.16257    0.11235 =
         0.14039    0.01622    0.01308   -0.02423
CA    1   -0.066087    0.217110    0.709056    11.00000    0.15009    0.11980 =
         0.15386    0.01426    0.00563   -0.03197
C     1   -0.082997    0.209609    0.702883    11.00000    0.13677    0.14224 =
         0.15538   -0.02240    0.02916   -0.02012
O     4   -0.096679    0.214469    0.709389    11.00000    0.14476    0.12973 =
         0.18678    0.00938    0.04441   -0.00235
CB    1   -0.058625    0.229254    0.695466    11.00000    0.17462    0.10655 =
         0.15060    0.02415    0.00947   -0.01599
CG    1   -0.071532    0.242201    0.688737    11.00000    0.14480    0.11501 =
         0.15911    0.00364    0.00141   -0.02326
CD1   1   -0.077537    0.255984    0.698307    11.00000    0.15320    0.13250 =
         0.16992   -0.01747   -0.01341   -0.00699
CD2   1   -0.077783    0.240156    0.672210    11.00000    0.13767    0.12339 =
         0.14193    0.00608    0.01110   -0.01673
CE1   1   -0.089484    0.267470    0.691558    11.00000    0.15183    0.16965 =
         0.14970   -0.01056   -0.00583    0.00907
CE2   1   -0.089746    0.251429    0.664880    11.00000    0.14194    0.11009 =
         0.16899   -0.00704    0.00392   -0.01449
CZ    1   -0.095367    0.265040    0.674891    11.00000    0.13962    0.13239 =
         0.15306   -0.01069    0.00066   -0.00201
OH    4   -0.107013    0.276781    0.668108    11.00000    0.16267    0.14451 =
         0.19100   -0.00086   -0.01647    0.01095
 
RESI 2017   LEU
N     3   -0.082244    0.197777    0.690393    11.00000    0.14251    0.11454 =
         0.15679   -0.00325    0.01205   -0.03080
CA    1   -0.097994    0.190461    0.683419    11.00000    0.14139    0.13121 =
         0.15829   -0.00383    0.01926   -0.03762
C     1   -0.107301    0.179250    0.696773    11.00000    0.13392    0.12873 =
         0.17293   -0.00261    0.02503   -0.02462
O     4   -0.123261    0.179760    0.697574    11.00000    0.12432    0.17765 =
         0.27106    0.01479    0.03943   -0.03061
CB    1   -0.093747    0.179678    0.667473    11.00000    0.21790    0.15684 =
         0.13577   -0.00282    0.00432   -0.03872
CG    1   -0.088545    0.190527    0.651659    11.00000    0.15367    0.16066 =
         0.14025    0.01053   -0.00186   -0.01802
CD1   1   -0.082016    0.178452    0.637550    11.00000    0.18462    0.22030 =
         0.15801   -0.04428    0.02072   -0.04916
CD2   1   -0.103346    0.201967    0.645824    11.00000    0.15168    0.20064 =
         0.21793    0.04385   -0.01788   -0.02143
 
RESI 2018   VAL
N     3   -0.097646    0.169174    0.706590    11.00000    0.16732    0.10196 =
         0.20838    0.01569    0.01813   -0.02608
CA    1   -0.105878    0.157169    0.718773    11.00000    0.18995    0.11549 =
         0.19023    0.00132    0.05316   -0.04410
C     1   -0.113281    0.167066    0.733566    11.00000    0.15897    0.12132 =
         0.21728   -0.00206    0.03003   -0.00576
O     4   -0.127645    0.163216    0.739576    11.00000    0.17933    0.17208 =
         0.23897   -0.01177    0.06359   -0.03234
CB    1   -0.092197    0.144088    0.725273    11.00000    0.27137    0.10319 =
         0.23893    0.03239    0.12232    0.01669
CG1   1   -0.097672    0.136140    0.741925    11.00000    0.23758    0.17078 =
         0.23558    0.04352    0.10055    0.01805
CG2   1   -0.089409    0.131170    0.710757    11.00000    0.28547    0.13511 =
         0.29349   -0.01843    0.15241   -0.03907
 
RESI 2019   CYS
N     3   -0.103552    0.179736    0.740012    11.00000    0.18119    0.12443 =
         0.16527    0.00301    0.03152   -0.01281
CA    1   -0.108573    0.187549    0.756519    11.00000    0.19041    0.14647 =
         0.17335   -0.00052    0.02058    0.01386
C     1   -0.122194    0.201638    0.754334    11.00000    0.19797    0.18443 =
         0.21391    0.01004    0.03914    0.03812
O     4   -0.131162    0.205674    0.766778    11.00000    0.24981    0.21955 =
         0.26301   -0.02523    0.08667    0.04025
CB    1   -0.092751    0.195018    0.766171    11.00000    0.20461    0.14333 =
         0.18081   -0.00059    0.00702   -0.00214
SG    5   -0.077867    0.177937    0.771578    11.00000    0.17652    0.14329 =
         0.19555    0.01068    0.02845   -0.01382
 
RESI 2020   GLY
N     3   -0.123963    0.208961    0.738954    11.00000    0.22519    0.15850 =
         0.23110    0.02155    0.00250    0.02914
CA    1   -0.137419    0.222025    0.736247    11.00000    0.27750    0.18778 =
         0.29725   -0.01481   -0.02933    0.07325
C     1   -0.136926    0.236343    0.749117    11.00000    0.27040    0.20121 =
         0.35234   -0.04878    0.02489    0.04106
O     4   -0.123106    0.242981    0.753586    11.00000    0.27058    0.18457 =
         0.33637   -0.04321    0.03687    0.03680
 
RESI 2021   GLU
N     3   -0.152274    0.241179    0.754901    11.00000    0.26872    0.22946 =
         0.36833   -0.04060    0.03259    0.04360
CA    1   -0.153117    0.256731    0.765826    11.00000    0.29443    0.22111 =
         0.43525   -0.04548    0.04243    0.09267
C     1   -0.144438    0.253247    0.783032    11.00000    0.21814    0.26085 =
         0.37949   -0.07676    0.07678    0.02633
O     4   -0.141748    0.265157    0.792915    11.00000    0.28348    0.33371 =
         0.46770   -0.16848    0.12109    0.01995
PART    1
CB    1   -0.171746    0.261912    0.769111    51.00000    0.29134    0.31854 =
         0.49960   -0.06968    0.02592    0.11505
CG    1   -0.184212    0.257645    0.754719    51.00000    0.28767    0.43269 =
         0.51991   -0.11705    0.03178    0.10400
CD    1   -0.201599    0.266135    0.757631    51.00000    0.28247    0.55496 =
         0.68365   -0.10142   -0.00122    0.14421
OE1   4   -0.206820    0.267932    0.772750    51.00000    0.14164    0.75004 =
         0.73208   -0.25459   -0.00229    0.11900
OE2   4   -0.209772    0.270969    0.744657    51.00000    0.33179    0.74827 =
         0.77961   -0.18550   -0.16599    0.14948
PART    2
CB    1   -0.171551    0.263475    0.766084   -51.00000    0.29059    0.35561 =
         0.51933   -0.12438   -0.00228    0.11367
CG    1   -0.176859    0.270272    0.748503   -51.00000    0.26995    0.50605 =
         0.53189   -0.10986   -0.02548    0.15178
CD    1   -0.166599    0.283903    0.739383   -51.00000    0.33452    0.72105 =
         0.53750    0.01948    0.05496    0.14931
OE1   4   -0.150959    0.287521    0.741278   -51.00000    0.29507    1.09894 =
         0.50624    0.20689    0.16847    0.10568
OE2   4   -0.174992    0.292598    0.728391   -51.00000    0.45192    0.96209 =
         0.39697    0.07603    0.03150    0.11094
 
RESI 2022   ARG
PART    0
N     3   -0.139377    0.237270    0.787482    11.00000    0.21465    0.27530 =
         0.33059   -0.02957    0.05681   -0.00008
CA    1   -0.130390    0.235153    0.803884    11.00000    0.27317    0.29552 =
         0.30886   -0.02796    0.06911   -0.05727
C     1   -0.112696    0.243571    0.803218    11.00000    0.24747    0.29389 =
         0.31311   -0.07227    0.04787   -0.03478
O     4   -0.105092    0.249885    0.815360    11.00000    0.23682    0.52971 =
         0.37042   -0.18928    0.00983    0.02695
PART    1
CB    1   -0.128249    0.215887    0.807858    41.00000    0.26917    0.33008 =
         0.32535    0.04948    0.11786   -0.02619
CG    1   -0.144953    0.205773    0.805828    41.00000    0.31824    0.28400 =
         0.29188   -0.02241    0.17850   -0.05271
CD    1   -0.142143    0.186493    0.809323    41.00000    0.39024    0.29864 =
         0.30020   -0.00603    0.14340   -0.02211
NE    3   -0.141025    0.176581    0.793427    41.00000    0.21966    0.23753 =
         0.26295    0.03731    0.11884   -0.00481
CZ    1   -0.139006    0.159696    0.792207    41.00000    0.34419    0.25338 =
         0.30342    0.05430    0.15509    0.08754
NH1   3   -0.137489    0.150039    0.806000    41.00000    0.27281    0.27515 =
         0.35332    0.09425    0.04461   -0.03136
NH2   3   -0.138128    0.152352    0.776647    41.00000    0.16667    0.20609 =
         0.34222    0.01158    0.02666   -0.04455
PART    2
CB    1   -0.129069    0.216040    0.808560   -41.00000    0.27010    0.32764 =
         0.33937    0.03501    0.07849   -0.03455
CG    1   -0.146991    0.208669    0.812368   -41.00000    0.28463    0.29812 =
         0.37981    0.02936    0.14699   -0.01474
CD    1   -0.146103    0.188874    0.810806   -41.00000    0.34569    0.29691 =
         0.30887    0.03020    0.15805   -0.02464
NE    3   -0.136401    0.181651    0.825003   -41.00000    0.41636    0.32866 =
         0.37919    0.06224    0.10564   -0.00817
CZ    1   -0.129715    0.166149    0.826893   -41.00000    0.43819    0.23550 =
         0.35848    0.03524    0.02639   -0.11496
NH1   3   -0.131446    0.154622    0.814521   -41.00000    0.36191    0.37733 =
         0.32726   -0.03250    0.12616   -0.11247
NH2   3   -0.121284    0.162187    0.841282   -41.00000    0.32507    0.26790 =
         0.24621    0.06663    0.16936   -0.09414
 
RESI 2023   GLY
PART    0
N     3   -0.105621    0.243516    0.787531    11.00000    0.20892    0.19847 =
         0.32373   -0.04024    0.04942   -0.01546
CA    1   -0.087369    0.246875    0.786166    11.00000    0.21008    0.17053 =
         0.33165    0.00440    0.02121   -0.03482
C     1   -0.076878    0.232240    0.794196    11.00000    0.20604    0.16931 =
         0.21967   -0.01980    0.05120   -0.03528
O     4   -0.083280    0.218406    0.798509    11.00000    0.22707    0.17413 =
         0.19477   -0.00670    0.03724   -0.04832
 
RESI 2024   PHE
N     3   -0.060092    0.235395    0.794955    11.00000    0.20199    0.15529 =
         0.21208   -0.00641    0.04912   -0.03203
CA    1   -0.048124    0.221569    0.799205    11.00000    0.22437    0.13817 =
         0.16306   -0.02863    0.01076   -0.03715
C     1   -0.031335    0.228969    0.805772    11.00000    0.22155    0.14261 =
         0.15840   -0.00238    0.02263   -0.05076
O     4   -0.028146    0.244544    0.803978    11.00000    0.23221    0.14506 =
         0.21549   -0.01071    0.02487   -0.05476
CB    1   -0.044707    0.210183    0.783427    11.00000    0.23584    0.13700 =
         0.14945   -0.00886    0.04081   -0.04570
CG    1   -0.037505    0.220297    0.768295    11.00000    0.19950    0.10959 =
         0.16860   -0.00292    0.02180   -0.03928
CD1   1   -0.019908    0.222259    0.766218    11.00000    0.20892    0.14762 =
         0.18999   -0.01547    0.03505   -0.06635
CD2   1   -0.048166    0.227433    0.755650    11.00000    0.25343    0.11476 =
         0.15759   -0.00524    0.00826   -0.03011
CE1   1   -0.012617    0.231333    0.752469    11.00000    0.20095    0.16350 =
         0.18501    0.01152    0.01942   -0.04710
CE2   1   -0.041785    0.236684    0.742044    11.00000    0.20586    0.13188 =
         0.17335   -0.00039    0.01664   -0.03440
CZ    1   -0.023879    0.238401    0.740441    11.00000    0.20682    0.14368 =
         0.19981   -0.02561    0.00058   -0.02678
 
RESI 2025   PHE
N     3   -0.020368    0.218040    0.811947    11.00000    0.22360    0.17506 =
         0.17547   -0.00555    0.01572   -0.02957
CA    1   -0.002506    0.222900    0.815377    11.00000    0.23485    0.18140 =
         0.20205   -0.02860    0.00151   -0.04160
C     1    0.009635    0.211502    0.804752    11.00000    0.20998    0.13724 =
         0.23758    0.02098   -0.00934   -0.02658
O     4    0.007033    0.196049    0.802933    11.00000    0.25807    0.14405 =
         0.25399   -0.00968    0.01670   -0.04078
CB    1    0.002085    0.222005    0.834379    11.00000    0.37053    0.24954 =
         0.22245   -0.02631   -0.06991   -0.05418
CG    1   -0.003957    0.206265    0.843886    11.00000    0.56091    0.29096 =
         0.21540    0.02182   -0.08141   -0.07656
CD1   1    0.007746    0.193354    0.848257    11.00000    0.74549    0.28897 =
         0.23743   -0.00455   -0.09719    0.01156
CD2   1   -0.021281    0.204293    0.848499    11.00000    0.61668    0.31346 =
         0.22595    0.01877    0.00000   -0.15568
CE1   1    0.002246    0.178803    0.857347    11.00000    0.93296    0.30491 =
         0.27474    0.03782   -0.15288   -0.02967
CE2   1   -0.026673    0.189830    0.857693    11.00000    0.79063    0.34022 =
         0.20777    0.02286   -0.03171   -0.21337
CZ    1   -0.014880    0.177148    0.862057    11.00000    0.97894    0.30027 =
         0.31853    0.03448   -0.11446   -0.17161
 
RESI 2026   TYR
N     3    0.022371    0.220001    0.797710    11.00000    0.22313    0.16555 =
         0.20588    0.01578    0.00557   -0.04105
CA    1    0.035407    0.211306    0.787380    11.00000    0.20713    0.16212 =
         0.19744    0.00954   -0.02601   -0.02085
C     1    0.052303    0.213359    0.797218    11.00000    0.23520    0.13938 =
         0.22259    0.01087   -0.05326   -0.01827
O     4    0.058751    0.227655    0.798176    11.00000    0.23876    0.14593 =
         0.26543    0.00727   -0.04500   -0.03124
CB    1    0.035929    0.219170    0.769596    11.00000    0.19896    0.16459 =
         0.19436    0.00912   -0.01662   -0.00888
CG    1    0.050366    0.212282    0.758823    11.00000    0.16963    0.16599 =
         0.20863    0.02806   -0.02398   -0.01766
CD1   1    0.051062    0.194923    0.754814    11.00000    0.20710    0.18288 =
         0.24213   -0.00666    0.00743   -0.00910
CD2   1    0.063266    0.223068    0.752609    11.00000    0.17537    0.23340 =
         0.18978    0.05370   -0.05020   -0.05602
CE1   1    0.064159    0.188058    0.744958    11.00000    0.23557    0.22508 =
         0.23105    0.02150    0.02871    0.01306
CE2   1    0.076577    0.216247    0.742545    11.00000    0.19078    0.28767 =
         0.19573    0.06493   -0.02995   -0.04648
CZ    1    0.076991    0.199115    0.738811    11.00000    0.17997    0.30295 =
         0.23878    0.04446   -0.01560   -0.00206
OH    4    0.090133    0.192119    0.728834    11.00000    0.20457    0.42013 =
         0.26427    0.03708    0.01315    0.03548
 
RESI 2027   THR
N     3    0.058617    0.199169    0.803993    11.00000    0.28125    0.16033 =
         0.21328    0.02088   -0.06235    0.00247
CA    1    0.073352    0.199739    0.815464    11.00000    0.33626    0.27682 =
         0.22349   -0.00178   -0.10360    0.05432
C     1    0.086261    0.186424    0.809275    11.00000    0.31871    0.21079 =
         0.22863    0.02295   -0.10390    0.02779
O     4    0.088210    0.172096    0.815453    11.00000    0.33227    0.21426 =
         0.36121    0.07123   -0.09199    0.00171
PART    1
CB    1    0.068222    0.196745    0.834378    81.00000    0.41758    0.38530 =
         0.21602   -0.02013   -0.09084    0.05317
OG1   4    0.054462    0.208247    0.838775    81.00000    0.40031    0.36441 =
         0.25694    0.00517   -0.03550    0.02609
CG2   1    0.083412    0.200536    0.846072    81.00000    0.49513    0.38175 =
         0.24243   -0.06999   -0.15623    0.11251
PART    2
CB    1    0.067374    0.195881    0.833993   -81.00000    0.42206    0.39985 =
         0.20874   -0.02922   -0.09040    0.03774
OG1   4    0.057475    0.180184    0.834438   -81.00000    0.46068    0.35028 =
         0.37766    0.16434   -0.09587    0.07416
CG2   1    0.055420    0.210048    0.840310   -81.00000    0.42448    0.41130 =
         0.22391    0.01929   -0.04172    0.05189
 
RESI 2028   PRO
PART    0
N     3    0.095397    0.191450    0.796029    11.00000    0.30285    0.19000 =
         0.24956    0.01091   -0.10045    0.02539
CA    1    0.107097    0.178981    0.788201    11.00000    0.31362    0.24579 =
         0.27314    0.01402   -0.09318    0.05695
C     1    0.122884    0.174588    0.798567    11.00000    0.29252    0.24661 =
         0.45070    0.05461   -0.13363    0.02687
O     4    0.130109    0.160810    0.795618    11.00000    0.26169    0.25235 =
         0.65761    0.04819   -0.13828    0.02866
CB    1    0.112037    0.188428    0.771705    11.00000    0.32846    0.24198 =
         0.28553   -0.01780   -0.05928   -0.03294
CG    1    0.110274    0.207153    0.775877    11.00000    0.27394    0.23530 =
         0.31854    0.00292   -0.07435   -0.00334
CD    1    0.094537    0.208290    0.787333    11.00000    0.28600    0.19630 =
         0.30049    0.03320   -0.07338   -0.01371
 
RESI 2029   LYS
PART    1
N     3    0.128995    0.185774    0.809942   101.00000    0.28079    0.30752 =
         0.47501    0.05008   -0.17583   -0.00392
CA    1    0.144999    0.179714    0.817993   101.00000    0.29984    0.34737 =
         0.56406    0.05086   -0.19460    0.03436
CB    1    0.157175    0.194804    0.820564   101.00000    0.32350    0.46886 =
         0.60762    0.02798   -0.23854   -0.03998
CG    1    0.149312    0.210366    0.829290   101.00000    0.55140    0.56619 =
         0.61832   -0.19194   -0.22607   -0.13343
CD    1    0.161476    0.225414    0.831489   101.00000    0.65171    0.64221 =
         0.68266   -0.16735   -0.18616   -0.23321
CE    1    0.151839    0.242426    0.832835   101.00000    0.69347    0.60382 =
         0.63996   -0.26881   -0.14305   -0.27355
NZ    3    0.152830    0.250798    0.850058   101.00000    0.56094    0.76564 =
         0.53076   -0.19428   -0.15470   -0.27162
C     1    0.140362    0.170237    0.834355   101.00000    0.34310    0.41226 =
         0.57180    0.10122   -0.22506    0.06619
O     4    0.150938    0.161279    0.841763   101.00000    0.41809    0.57052 =
         0.65720    0.15309   -0.27755    0.11727
PART    2
N     3    0.127545    0.185063    0.811136   111.00000    0.30772    0.26523 =
         0.44803    0.09156   -0.20159   -0.00672
CA    1    0.139376    0.181266    0.825058   111.00000    0.29958    0.35580 =
         0.56331    0.09566   -0.25302    0.05225
CB    1    0.136166    0.163057    0.831840   111.00000    0.39058    0.38405 =
         0.60033    0.17220   -0.22654    0.12108
CG    1    0.117854    0.159248    0.837596   111.00000    0.49383    0.41871 =
         0.66490    0.22278   -0.09795    0.07186
CD    1    0.113139    0.168991    0.853879   111.00000    0.53816    0.45366 =
         0.66486    0.21293   -0.09458    0.07843
CE    1    0.099177    0.159919    0.864140   111.00000    0.58366    0.52384 =
         0.63075    0.18361   -0.09143    0.01565
NZ    3    0.103418    0.141454    0.867131   111.00000    0.64733    0.49947 =
         0.73552    0.20263   -0.12764   -0.05363
C     1    0.158085    0.183261    0.819668   111.00000    0.31261    0.42004 =
         0.56921    0.03529   -0.20400    0.09079
O     4    0.169234    0.186276    0.830536   111.00000    0.30065    0.68436 =
         0.65885    0.11642   -0.24952    0.01477
 
RESI 2030   ALA
PART    1
CB    1    0.111249    0.172344    0.869336   101.00000    0.70197    0.43094 =
         0.64279    0.22581   -0.04734    0.10556
C     1    0.104870    0.148536    0.848627   101.00000    0.59030    0.54590 =
         0.70678    0.17997   -0.08015   -0.00996
OT1   4    0.107223    0.141809    0.834244   101.00000    0.53653    0.66134 =
         0.81301    0.05567    0.04407   -0.20100
N     3    0.124519    0.171546    0.840368   101.00000    0.42600    0.44272 =
         0.64332    0.18906   -0.11109    0.11990
CA    1    0.118451    0.161309    0.854925   101.00000    0.56113    0.46584 =
         0.63901    0.17967   -0.10434    0.06269
OT2   4    0.092280    0.145814    0.858249   101.00000    0.69512    0.62015 =
         0.55428    0.19422   -0.09155   -0.09073
PART    2
CB    1    0.178495    0.175236    0.777444   111.00000    0.56905    0.61870 =
         0.55764    0.12528   -0.09621    0.30059
C     1    0.187876    0.199063    0.796517   111.00000    0.55434    0.68114 =
         0.63508    0.09031   -0.05191    0.19726
OT1   4    0.191682    0.205562    0.810695   111.00000    0.68030    0.62771 =
         0.67639    0.09991   -0.11127    0.13290
N     3    0.161526    0.181818    0.803118   111.00000    0.48591    0.54080 =
         0.60538   -0.02591   -0.13334    0.23275
CA    1    0.178823    0.181709    0.796046   111.00000    0.52369    0.62827 =
         0.63575    0.01910   -0.08409    0.25936
OT2   4    0.191337    0.205877    0.782359   111.00000    0.59306    0.76288 =
         0.67231    0.15251   -0.00674    0.29338
 
RESI 2501   GLC
PART   -2
O1    5   -0.138821    0.149493    0.677539   121.00000    0.66058    0.43423 =
         0.52960   -0.01865    0.00128   -0.04629
O2    5   -0.143085    0.160558    0.646360   121.00000    0.38615    0.66177 =
         0.62055   -0.11547    0.18228   -0.05992
O3    5   -0.186445    0.139344    0.646593   121.00000    0.75511    0.52294 =
         0.39052    0.18592   -0.18535   -0.35165
C1    1   -0.156095    0.151290    0.672264   121.00000    0.59517    0.63735 =
         0.46892   -0.13880    0.07845   -0.11729
C2    1   -0.156418    0.149666    0.652996   121.00000    0.55541    0.64129 =
         0.46549   -0.11240    0.08058   -0.19157
C3    1   -0.174112    0.153109    0.644485   121.00000    0.49992    0.60615 =
         0.44666   -0.04161    0.12516   -0.27414
 
RESI 3001   HOH
PART 0
O     4    0.097922    0.159735    0.710818    11.00000    0.20020    0.30449 =
         0.27576    0.11843   -0.01455   -0.03782
 
RESI 3002   HOH
O     4   -0.021643    0.214755    0.576950    11.00000    0.15394    0.53712 =
         0.13749   -0.03076   -0.02212    0.10693
 
RESI 3003   HOH
O     4    0.070404    0.123643    0.625739    11.00000    0.32018    0.29739 =
         0.21490    0.03034    0.02802    0.04281
 
RESI 3004   HOH
O     4    0.034814    0.172252    0.804459    11.00000    0.36595    0.17341 =
         0.39222    0.02739    0.10430   -0.03862
 
RESI 3005   HOH
O     4    0.042265    0.013653    0.764489    11.00000    0.28256    0.12205 =
         0.67310    0.01125   -0.12244    0.01137
 
RESI 3006   HOH
O     4   -0.082864    0.015817    0.746274    11.00000    0.28354    0.18354 =
         0.53438   -0.05657    0.09980   -0.05806
 
RESI 3007   HOH
O     4    0.107093    0.132301    0.799234    11.00000    0.31824    0.32288 =
         0.34359    0.05445   -0.09492   -0.08014
 
RESI 3008   HOH
O     4   -0.084272    0.084272    0.584272    10.33300    0.31395    0.31395 =
         0.31395    0.06775   -0.06775   -0.06775
 
RESI 3009   HOH
O     4   -0.008793    0.152725    0.626543    11.00000    0.25299    0.24693 =
         0.28833   -0.02500   -0.07814    0.00948
 
RESI 3010   HOH
O     4   -0.091822    0.237409    0.739890    11.00000    0.28557    0.28866 =
         0.27080   -0.09038    0.07777   -0.03130
 
RESI 3011   HOH
O     4    0.094876    0.170853    0.623425    11.00000    0.25828    0.28646 =
         0.29626    0.07742    0.05354   -0.04816
 
RESI 3012   HOH
O     4   -0.028917   -0.002660    0.704017    11.00000    0.18216    0.16024 =
         0.83641   -0.10222   -0.06554   -0.01125
 
RESI 3013   HOH
O     4    0.117617    0.207585    0.721015    11.00000    0.22144    0.69312 =
         0.47792    0.20119    0.01404   -0.01216
 
RESI 3014   HOH
O     4   -0.131315    0.296116    0.685740    11.00000    0.27447    0.50199 =
         0.36006   -0.09136    0.05819    0.06104
 
RESI 3015   HOH
O     4   -0.097686    0.102401    0.850728    11.00000    0.55982    0.29639 =
         0.30060    0.04658   -0.02495   -0.05424
 
RESI 3016   HOH
O     4   -0.047760    0.155451    0.614074    11.00000    0.30143    0.32629 =
         0.24876   -0.01588    0.01462    0.03068
 
RESI 3017   HOH
O     4   -0.097936    0.078697    0.652448    11.00000    0.25148    0.34971 =
         0.39463   -0.05047   -0.02718    0.00675
 
RESI 3018   HOH
O     4    0.048019    0.034838    0.614484    11.00000    0.36834    0.46055 =
         0.35639   -0.18700    0.02922    0.04469
 
RESI 3019   HOH
O     4    0.121698    0.068874    0.652096    11.00000    0.32760    0.34560 =
         0.42578   -0.00305    0.13835   -0.04155
 
RESI 3020   HOH
O     4   -0.020916    0.243125    0.618464    11.00000    0.24948    0.38922 =
         0.40971   -0.01139    0.00077    0.03976
 
RESI 3021   HOH
O     4   -0.055264    0.046036    0.624147    11.00000    0.66851    0.27735 =
         0.50239   -0.10363   -0.28293    0.06814
 
RESI 3022   HOH
O     4    0.132325    0.155546    0.709453    11.00000    0.23625    0.39717 =
         0.45185    0.11362    0.06550    0.01737
 
RESI 3023   HOH
O     4   -0.103469    0.003844    0.869715    11.00000    0.31760    0.45780 =
         0.38131    0.06628    0.04612    0.05150
 
RESI 3024   HOH
O     4   -0.014348    0.257309    0.652345    11.00000    0.37974    0.30170 =
         0.36051   -0.02258   -0.05943    0.02012
 
RESI 3025   HOH
O     4    0.063246    0.146573    0.824101    11.00000    0.56409    0.35397 =
         0.30249   -0.04348    0.03190   -0.18772
 
RESI 3026   HOH
O     4    0.034782    0.113873    0.607575    11.00000    0.45464    0.33923 =
         0.46261   -0.02309   -0.01225   -0.04301
 
RESI 3027   HOH
O     4    0.110806    0.007906    0.811160    10.50000    0.33475    0.20141 =
         0.67032   -0.06060   -0.28460   -0.03275
 
RESI 3028   HOH
O     4    0.121971    0.167496    0.638804    11.00000    0.39344    0.62695 =
         0.53655    0.00843    0.16859   -0.25803
 
RESI 3029   HOH
O     4   -0.005780    0.125399    0.868183    11.00000    0.50628    0.72500 =
         0.45932    0.22353   -0.13963   -0.09096
 
RESI 3030   HOH
O     4    0.091975    0.057081    0.829159    11.00000    0.67115    0.34967 =
         0.44588    0.13042   -0.09790    0.01820
 
RESI 3031   HOH
O     4   -0.095877    0.136775    0.849550    10.50000    0.33576    0.39226 =
         0.32536   -0.01733    0.16919    0.01905
 
RESI 3032   HOH
O     4   -0.143301    0.134205    0.749991    11.00000    0.41404    0.52891 =
         0.69496    0.36569   -0.11599   -0.15630
 
RESI 3033   HOH
O     4   -0.002153    0.077167    0.828309    10.50000    0.45488    0.48326 =
         0.36732    0.01735   -0.02458   -0.21766
 
RESI 3034   HOH
O     4   -0.181566    0.225234    0.743714    10.50000    0.17889    0.41235 =
         0.67459   -0.13344   -0.03761    0.00671
 
RESI 3035   HOH
O     4   -0.186583    0.128751    0.735253    10.50000    0.70459    0.42556 =
         0.26008    0.01084   -0.06254    0.37776
 
RESI 3036   HOH
O     4   -0.132807    0.327901    0.675852    11.00000    0.31965    0.34349 =
         0.54272   -0.15822   -0.05821    0.02143
 
RESI 3037   HOH
O     4    0.022585    0.064578    0.823145    10.50000    0.41370    0.59628 =
         0.51237   -0.15546   -0.16918    0.30936
 
RESI 3038   HOH
O     4   -0.053421    0.044055    0.872414    10.50000    0.45774    0.36637 =
         0.44664    0.16466   -0.18067   -0.10920
 
RESI 3039   HOH
O     4    0.133889    0.037102    0.645700    10.50000    0.50997    0.51454 =
         0.57923    0.03871    0.31242    0.08329
 
RESI 3040   HOH
O     4    0.150378    0.094291    0.714119    11.00000    0.61685    0.33858 =
         0.66924    0.20364    0.01872   -0.01506
 
RESI 3041   HOH
O     4   -0.114521    0.282923    0.823705    11.00000    0.64030    0.32817 =
         0.47266    0.00995    0.23327   -0.06823
 
RESI 3042   HOH
O     4    0.154283    0.128647    0.706547    11.00000    0.30895    0.48039 =
         0.66951    0.23381    0.00445   -0.02979
 
RESI 3043   HOH
O     4    0.122438    0.021048    0.759341    10.50000    0.41974    0.46994 =
         0.47405    0.15617   -0.25540   -0.02251
 
RESI 3044   HOH
O     4   -0.156252    0.180291    0.719578    11.00000    0.41538    0.37427 =
         0.67618   -0.03589   -0.14266    0.04025
 
RESI 3045   HOH
O     4    0.149188    0.168549    0.740267    10.50000    0.28576    0.41350 =
         0.50295   -0.09621    0.09858   -0.17309
 
RESI 3046   HOH
O     4   -0.023976    0.255022    0.863167    11.00000    0.83559    0.59985 =
         0.46667   -0.01665    0.32651   -0.09098
 
RESI 3047   HOH
O     4    0.153261    0.082764    0.749804    10.50000    0.32128    0.35913 =
         0.42295    0.00450   -0.08811    0.06800
 
RESI 3048   HOH
O     4    0.150477    0.025161    0.686236    10.50000    0.26520    0.36960 =
         0.68394   -0.02847    0.22052    0.05482
 
RESI 3049   HOH
O     4    0.112763    0.098254    0.860359    10.50000    0.62753    0.32677 =
         0.34820    0.03632   -0.27752   -0.03885
 
RESI 3050   HOH
O     4   -0.153304    0.299255    0.778656    11.00000    0.47068    0.42903 =
         0.71687   -0.01772    0.07028   -0.04072
 
RESI 3051   HOH
O     4    0.015029    0.038479    0.851731    10.50000    0.70626    0.37858 =
         0.35555   -0.02272   -0.07144    0.14501
 
RESI 3052   HOH
O     4    0.094862    0.111606    0.614254    10.50000    0.44367    0.38075 =
         0.49229   -0.06007   -0.01293    0.15422
 
RESI 3053   HOH
O     4    0.066955    0.069366    0.838864    10.50000    0.62199    0.38883 =
         0.30627    0.01658   -0.04778   -0.03622
 
RESI 3054   HOH
O     4   -0.206781    0.144446    0.750281    10.50000    0.41896    0.54837 =
         0.47442   -0.05069    0.01255   -0.05674
 
RESI 3055   HOH
O     4    0.001265    0.095285    0.863003    11.00000    0.42861    0.51138 =
         0.64881   -0.14050   -0.13211    0.06395
 
RESI 3056   HOH
O     4   -0.088801    0.028406    0.625361    10.50000    0.39761    0.50498 =
         0.48137    0.24359   -0.03968   -0.03584
 
RESI 3057   HOH
O     4    0.148916    0.111185    0.659047    10.50000    0.39227    0.70556 =
         0.49227    0.21598    0.19824    0.00975
 
RESI 3058   HOH
O     4   -0.163387    0.183137    0.763302    10.50000    0.51684    0.46679 =
         0.42431    0.13973   -0.14114   -0.24448
 
RESI 3059   HOH
O     4    0.002813    0.000000    0.750000    10.50000    0.20085    1.05341 =
         0.31473   -0.15183    0.00000    0.00000
 
RESI 3060   HOH
O     4    0.135485    0.126471    0.634621    11.00000    0.56420    1.09843 =
         0.86041    0.24326    0.46584   -0.02412
 
RESI 3061   HOH
O     4   -0.067919    0.159871    0.868336    11.00000    0.93459    0.74202 =
         0.49572    0.31439    0.07365    0.17549
 
RESI 3062   HOH
O     4    0.168896    0.052051    0.754267    11.00000    0.58567    0.81269 =
         0.81592   -0.08082   -0.06204    0.00740
 
RESI 3063   HOH
O     4    0.057807    0.134124    0.857075    11.00000    0.59495    0.71746 =
         0.45372    0.02817    0.04396    0.10418
 
RESI 3064   HOH
O     4   -0.002482   -0.006004    0.625990    11.00000    1.14722    0.72394 =
         0.92442   -0.51518   -0.02794    0.04801
 
RESI 3065   HOH
O     4    0.045841    0.075734    0.604877    11.00000    0.61590    0.65788 =
         0.30767   -0.04963    0.09788   -0.04604
 
RESI 3066   HOH
O     4   -0.142722    0.187623    0.669882    10.50000    0.24422    0.69506 =
         0.37126    0.07924    0.09313   -0.13741
 
RESI 3067   HOH
O     4    0.154636    0.080005    0.673480    10.50000    0.30160    0.47029 =
         0.83850   -0.21206    0.25632   -0.06474
 
RESI 3068   HOH
O     4    0.068320    0.105490    0.578738    10.50000    0.72788    0.33252 =
         0.52237   -0.08578   -0.03318    0.10983
 
REM  insulin refinement
REM R1(Free) =  0.2474 for   790 Fo > 4sig(Fo)  and  0.2748 for all   954 data
REM R1 =  0.2386 for  14969 Fo > 4sig(Fo)  and  0.2612 for all  18003 data
REM   1603 parameters refined using   1644 restraints
 
REM Highest difference peak  0.822,  deepest hole -0.362,  1-sigma level  0.079
 
REM  insulin refinement
REM R1(Free) =  0.2143 for   790 Fo > 4sig(Fo)  and  0.2396 for all   954 data
REM R1 =  0.2064 for  14969 Fo > 4sig(Fo)  and  0.2276 for all  18003 data
REM   1756 parameters refined using   1732 restraints
 
REM Highest difference peak  0.691,  deepest hole -0.302,  1-sigma level  0.069
 
REM  insulin refinement
REM R1(Free) =  0.2121 for   790 Fo > 4sig(Fo)  and  0.2355 for all   954 data
REM R1 =  0.1921 for  14969 Fo > 4sig(Fo)  and  0.2130 for all  18003 data
REM   1867 parameters refined using   1764 restraints
 
REM Highest difference peak  0.717,  deepest hole -0.340,  1-sigma level  0.065
 
REM  insulin refinement
REM R1(Free) =  0.1710 for   790 Fo > 4sig(Fo)  and  0.1928 for all   954 data
REM R1 =  0.1462 for  14969 Fo > 4sig(Fo)  and  0.1633 for all  18003 data
REM   4191 parameters refined using   5062 restraints
 
REM Highest difference peak  0.636,  deepest hole -0.292,  1-sigma level  0.055
 
REM  insulin refinement
REM R1(Free) =  0.1561 for   790 Fo > 4sig(Fo)  and  0.1797 for all   954 data
REM R1 =  0.1368 for  14969 Fo > 4sig(Fo)  and  0.1538 for all  18003 data
REM   4287 parameters refined using   5164 restraints
 
REM Highest difference peak  0.660,  deepest hole -0.216,  1-sigma level  0.051
 
REM  insulin refinement
REM R1(Free) =  0.1467 for   790 Fo > 4sig(Fo)  and  0.1705 for all   954 data
REM R1 =  0.1302 for  14969 Fo > 4sig(Fo)  and  0.1470 for all  18003 data
REM   4492 parameters refined using   5301 restraints
 
REM Highest difference peak  0.632,  deepest hole -0.218,  1-sigma level  0.048
 
HKLF 4
 
REM  cubic insulin refinement
REM R1(Free) =  0.1471 for   790 Fo > 4sig(Fo)  and  0.1703 for all   954 data
REM R1 =  0.1261 for  14969 Fo > 4sig(Fo)  and  0.1427 for all  18003 data
REM   4684 parameters refined using   6043 restraints
 
END  
     
WGHT      0.2000      0.0000 
REM Highest difference peak  0.562,  deepest hole -0.204,  1-sigma level  0.046
Q13   4   0.0320 -0.0002  0.6166  11.00000  0.75    0.21
Q18   4   0.0900  0.0459  0.6001  11.00000  0.75    0.20
Q22   4   0.1698  0.0831  0.8197  11.00000  0.75    0.19
Q24   4   0.1102  0.1082  0.5586  11.00000  0.75    0.19
Q25   4  -0.1500  0.1992  0.8554  11.00000  0.75    0.19
Q28   4   0.0448  0.1687  0.8697  11.00000  0.75    0.18
Q29   4   0.0062  0.0911  0.5659  11.00000  0.75    0.18
Q31   4   0.0970  0.0073  0.6011  11.00000  0.75    0.18
Q32   4  -0.0091  0.0683  0.8819  11.00000  0.75    0.18
Q33   4  -0.0082  0.2166  0.8930  11.00000  0.75    0.18
Q41   4   0.1513  0.1426  0.7805  11.00000  0.75    0.17
Q52   4   0.0199  0.1358  0.8791  11.00000  0.75    0.16
Q53   4  -0.0351  0.1324  0.6372  11.00000  0.75    0.16
Q56   4   0.1064  0.0833  0.6226  11.00000  0.75    0.16
Q64   4   0.0782  0.1045  0.8716  11.00000  0.75    0.16
Q71   4   0.2006  0.1529  0.8351  11.00000  0.75    0.16
Q92   4  -0.0732  0.2118  0.8956  11.00000  0.75    0.15
Q93   4  -0.0264  0.0980  0.8877  11.00000  0.75    0.15
Q96   4   0.0016  0.0392  0.5780  11.00000  0.75    0.15
Q99   4   0.1566  0.0229  0.7511  11.00000  0.75    0.15
Q102  4   0.1504  0.1830  0.8797  11.00000  0.75    0.14
Q111  4  -0.1536  0.1505  0.7134  11.00000  0.75    0.14
Q120  4   0.0396  0.1035  0.8590  11.00000  0.75    0.14
Q124  4   0.1995  0.1027  0.6710  11.00000  0.75    0.14
Q128  4  -0.0397  0.1635  0.9000  11.00000  0.75    0.14
Q139  4   0.1705  0.0503  0.6938  11.00000  0.75    0.14
Q141  4  -0.1625  0.2977  0.6834  11.00000  0.75    0.14
Q150  4   0.1843  0.0500  0.7279  11.00000  0.75    0.13
Q167  4   0.1231  0.0648  0.8375  11.00000  0.75    0.13
Q168  4  -0.1111  0.2740  0.8612  11.00000  0.75    0.13
Q184  4   0.1390  0.0302  0.8125  11.00000  0.75    0.13
