
;; needed files:
;;  "rnasa-1.8-all_refmac1.mtz"
;;  "crankshaft-baddie.pdb"
;;  "reference.pdb"
;;  "wonky-N-terminus.pdb"
;; EMD-6771
;;  "5xtb-sans-J.pdb"
;;  "emd_6771_rebox.map"

(define (refine-active-fragment)

  (using-active-atom
   (let ((residues (linked-residues-scm aa-res-spec aa-imol 2.0)))
     (if (list? residues)
	 (refine-residues aa-imol residues)))))



(set-nomenclature-errors-on-read "ignore")

(let ((crankshaft-fn
       (lambda ()
	 (let ((imol-map (make-and-draw-map "rnasa-1.8-all_refmac1.mtz" "FWT" "PHWT" "" 0 0))
	       (imol (read-pdb "crankshaft-baddie.pdb")))
	   (set-map-colour imol-map 0.4 0.4 0.8)
	   (set-only-last-model-molecule-displayed)
	   (set-go-to-atom-molecule imol)
	   (set-molecule-bonds-colour-map-rotation imol 20)
	   (set-go-to-atom-chain-residue-atom-name "A" 50 " CA ")
	   (sharpen imol-map 100))))

      (compare-fn
       (lambda ()
	 (let ((imol (handle-read-draw-molecule-with-recentre "reference.pdb" 0)))
	   (set-mol-active imol 0))))

      (compare-baton-build-fn
       (lambda ()
	 (let ((imol (handle-read-draw-molecule-with-recentre "5xtb-sans-J.pdb" 0)))
	   (set-mol-active    imol 0)
	   (set-mol-displayed imol 0)
           (let ((imol-frag (new-molecule-by-atom-selection imol "//B/90-150/CA,C,N,O,CB")))
               imol))))

      (backrub-rotamers-fn (lambda () 1))

      (wonky-n-terminus-fn
       (lambda ()
	 (let ((imol-map (make-and-draw-map "rnasa-1.8-all_refmac1.mtz" "FWT" "PHWT" "" 0 0))
	       (imol (read-pdb "wonky-N-terminus.pdb")))
	   (set-imol-refinement-map imol-map)
	   (set-map-colour imol-map 0.3 0.4 0.6)
	   (set-only-last-model-molecule-displayed)
	   (set-go-to-atom-molecule imol)
	   (set-molecule-bonds-colour-map-rotation imol 20)
	   (let ((here-view (add-view-here "Start"))
		 (target-view (add-view (list    53.213 9.642 -1.042)
					(list 0.382241 -0.139104 0.367316 0.836433)
					34.0 "Wonky")))
	     (go-to-view-number target-view 0))
	   ;; 53 10 0
	   (set-go-to-atom-chain-residue-atom-name "A" 5 " CA "))))

      (baton-building-fn
       (lambda ()
	 (map close-molecule (model-molecule-list))
	 (map close-molecule (map-molecule-list))
	 (let ((imol-map (handle-read-ccp4-map "emd_6771_rebox.map" 0)))
	   (let ((imol (handle-read-draw-molecule-with-recentre "5xtb-sans-J.pdb" 0)))
	     (set-go-to-atom-molecule imol)
	     (set-go-to-atom-chain-residue-atom-name "B" 149 " CA ")
	     (set-mol-displayed imol 0)
	     (set-mol-active    imol 0)))))

      (contact-dots-on-fn
       (lambda ()
	 (set-do-coot-probe-dots-during-refine 1)))

      (contact-dots-off-fn
       (lambda ()
	 (set-do-coot-probe-dots-during-refine 0)))

      (rota-markup-on-fn
       (lambda ()
	 (set-show-intermediate-atoms-rota-markup 1)))

      (rota-markup-off-fn
       (lambda ()
	 (set-show-intermediate-atoms-rota-markup 0)))
      
      (interactive-pepflip-fn
       (lambda ()
	 (pepflip-intermediate-atoms)))

      (interactive-crankshaft-fn
       (lambda()
	 (crankshaft-peptide-rotation-optimization-intermediate-atoms)))

      (interactive-rotamer-fn
       (lambda()
	 (backrub-rotamer-intermediate-atoms)))

      (coot-points-fn
       (lambda ()
	 (let* ((score 146.6)
		(message (format #f "You have collected\n  ~s  \nCoot Points" score)))
	   (let ((window (gtk-window-new 'toplevel))
		 (vbox (gtk-vbox-new #f 2))
		 (message-text (gtk-label-new message))
		 (h-sep (gtk-hseparator-new))
		 (hbox-for-buttons (gtk-hbox-new #f 4))
		 (next-button  (gtk-button-new-with-label "Is that Good?"))
		 (close-button (gtk-button-new-with-label "   Close   ")))

	     (gtk-window-set-title window "Coot Points")
	     (gtk-box-pack-start vbox message-text #f #f 4)
	     (gtk-box-pack-start vbox h-sep #f #f 4)
	     (gtk-box-pack-start vbox hbox-for-buttons #f #f 4)
	     (gtk-box-pack-start hbox-for-buttons  next-button #f #f 4)
	     (gtk-box-pack-start hbox-for-buttons close-button #f #f 4)
	     (gtk-box-set-homogeneous hbox-for-buttons #t)
	     (gtk-container-add window vbox)

	     (gtk-signal-connect next-button "clicked" 
				 (lambda ()
				   (let ((message "Not for you, $USER == Ana,\n  12.6% below average"))
				     (info-dialog message)
				     (gtk-widget-destroy window))))
	     (gtk-signal-connect close-button "clicked"
				 (lambda () (gtk-widget-destroy window)))
	     (gtk-widget-show-all window)))))


      (set-refinement-update-rate-fn
       (lambda ()
	 (generic-single-entry "Frames per update"
			       "60"
			       "Set" (lambda(text)
				       (let ((n (string->number text)))
					 (if (number? n)
					     (set-dragged-refinement-steps-per-frame n))))))))

  (let ((buttons
	 (list
	  (list "\"Hello\"" (lambda () (info-dialog "Hello Ana.")))
	  (list "Basic Keybindings" (lambda () 'x))
	  (list "How to add \"Sphere Refine\"..." (lambda () 'x))
	  (list "Crankshaft Peptide" crankshaft-fn)
	  (list "Refine Fragment" refine-active-fragment)
	  (list "Compare vs Reference" compare-fn)
	  (list "Wonky N-terminus" wonky-n-terminus-fn)
	  (list "Set Frames per Update" set-refinement-update-rate-fn)
	  ;; (list "Backrub Rotamer" backrub-rotamers-fn)
	  (list "Open EM map (Baton-Building)" baton-building-fn)
          (list "Compare with Reference: 5xtb" compare-baton-build-fn)
	  (list "Intemediate Contact Dots On"  contact-dots-on-fn)
	  (list "Intemediate Contact Dots Off"  contact-dots-off-fn)
	  (list "Rotamer Markup On"  rota-markup-on-fn)
	  (list "Rotamer Markup Off" rota-markup-off-fn)
	  (list "I: Pepflip" interactive-pepflip-fn)
	  (list "I: Rotamer" interactive-rotamer-fn)
	  (list "I: 3CPO" interactive-crankshaft-fn)
	  (list "Coot Points" coot-points-fn)
	  )))

  (dialog-box-of-buttons "LMB Coot Demo" (cons 240 500) buttons " Close ")))

