
#include "instanced-vertex.hh"
#include "gl-lights-info.hh"
#include "Shader.hh"
#include "Material.hh"

class graphical_triangle {
public:
   graphical_triangle(const unsigned int &a0,
                      const unsigned int &a1,
                      const unsigned int &a2) {
      point_id[0] = a0;
      point_id[1] = a1;
      point_id[2] = a2;
   }
   unsigned int point_id[3];
};

class graphical_molecule {
public:
   graphical_molecule() { object_is_instanced = false; n_instances = -1; }
   GLuint vao;
   GLuint buffer_id;
   GLuint index_buffer_id;
   std::vector<instanced_vertex> vertices;
   std::vector<graphical_triangle> triangle_vertex_indices;
   Material material;
   bool object_is_instanced;
   int n_instances;
   void setup_simple_triangles(Shader *shader, const Material &material);
   void setup_rama_balls(Shader *shader_p, const Material &material); // call fill_rama_balls() and setup_buffers()
   void setup_instanced_balls(Shader *shader_p, const Material &material);
   // setup_simple_triangles() calls fill_with_simple_triangles_vertices()
   void fill_with_simple_triangles_vertices();

   // can be considered as "draw_self()"
   void draw(Shader *shader,
             const glm::mat4 &mvp,
             const std::map<unsigned int, gl_lights_info_t> &lights);

   void fill_rama_balls(); // make up some balls
   void add_one_ball(const glm::vec3 &centre);
   void add_one_origin_ball();
   void fill_one_dodec();
   void setup_buffers(const Shader::Entity_t &e); // buffers are setup differently if we use
                                                  // instancing
};
