# coot_load_modules+gui.py

# Copyright 2004, 2005, 2006, 2007 by the University of York
# Author: Bernhard Lohkamp, Paul Emsley

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or (at
# your option) any later version.

# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc.,  51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA

# load coot python modules (including gui s)

import os
import sys
import traceback

# define some globals

# This is full pathname of molprobity's probe program
# deftexi probe_command
global probe_command
probe_command = 'probe'

# This is full pathname of molprobity's reduce program
# deftexi reduce_command
global reduce_command
reduce_command = 'reduce'

# This has be be here (in a general place) because tips_gui (where it
# used to be is conditionally loaded).
# (default to tips_gui displayed is True).
# deftexi do_coot_tips_flag
global do_coot_tips_flag
do_coot_tips_flag = False

# coot tips have been removed from the list of files to load but
# there may be users who have no_coot_tips() in their ~/.coot script.
# Or run at startup (like CCP4). Give it an empty function.
#
def no_coot_tips():
    pass

# this is the variable we check so that coot doesn't double-load its extensions
# - this is set in src/main.cc
global use_gui_qm
global have_guile_gtk

pre_list = ["redefine_functions.py",
            "coot_utils.py",
            "filter.py",
            "coot_lsq.py",
            "shelx.py",
            "get_ebi.py",
            "local_code.py",
            # hello might give some people problems (according to Paul, it does
            # in the scheme version), if so, just comment out the next line:
            "hello.py",
            "mutate.py",
            "refmac.py",
            "libcheck.py",
            "gap.py",
            "fitting.py",
            "raster3d.py",
            "povray.py",
            "remote_control.py",
            "generic_objects.py",
            "ncs.py",
            "parse_pisa_xml.py",
            "cns2coot.py",
            "clear_backup.py",
            "tips.py",
            "generator_3d_import.py",
            "dictionary_generators.py",
            "jligand.py",
            "americanisms.py",
            "group_settings.py"]
post_list = ["coot_gui.py",
#            "tips_gui.py",
            "gui_hole.py",
            "gui_prosmart.py",
            "gui_add_linked_cho.py",
            "cho_restraints_from_models.py",
            "add_linked_cho.py",
            "gui_contact_score_isolated_ligand.py",
            "jligand_gui.py",
            "get_recent_pdbe.py",
            "extensions.py",
            "shelx_extensions.py",
            "enhanced_ligand.py",
            "ligand_check.py",
            "acedrg_link.py",
            "sharpen_blur.py",
            "dynamic_atom_overlaps_and_other_outliers.py",
            "interactive_nudge_residues.py",
            "gui_ligand_sliders.py",
            "find_baddies.py",
            "coot_toolbuttons.py",
            "pdbe_validation_data.py",
            "contact_score_isolated_ligand.py",
            "ligand_validation_sliders.py",
            "rcrane_loader.py" # calls set_found_coot_gui()
]

# list of modules not available on Windows
non_win_list = ["brute_lsqman.py"]

python_list = pre_list

if (os.name != 'nt'):
    python_list += non_win_list

# are we running unittesting?
coot_unittesting = False
for arg in sys.argv:
    if "coot_unittest.py" in arg:
        coot_unittesting = True
        break

have_coot_python = False
if use_gui_qm:
    # some test that sets have_coot_python
    have_coot_python = False

# we can't import the gui (coot_gui and extenstions) here
# because realize() hasn't been called yet

import redefine_functions
import ncs
import coot_utils
import fitting
import filter
import coot_lsq
import shelx
import get_ebi
import local_code
import hello
import mutate
import refmac
import libcheck
import gap
import raster3d
import povray
# import remote_control
import generic_objects
import parse_pisa_xml
import cns2coot
import clear_backup
